/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.parser;

import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.parser.ScannerPosition;
import com.googlecode.paradox.parser.Token;
import com.googlecode.paradox.parser.TokenType;
import java.nio.CharBuffer;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Queue;

public class Scanner {
    private static final char[] SEPARATORS = new char[]{' ', '\b', '\t', '\n', '\u0000', '\r'};
    private static final char[] SPECIAL = new char[]{'(', ')', '+', '-', ',', '.', '=', ';', '*'};
    private final CharBuffer buffer;
    private final Queue<Character> preloaded = new ArrayDeque<Character>();
    private final ArrayList<Token> tokens = new ArrayList();
    private final StringBuilder value = new StringBuilder(299);
    private final ScannerPosition position = new ScannerPosition();
    private ScannerPosition startPosition;

    Scanner(String buffer) throws SQLException {
        if (buffer == null || buffer.trim().isEmpty()) {
            throw new ParadoxSyntaxErrorException(SyntaxError.EMPTY_SQL);
        }
        this.buffer = CharBuffer.wrap(buffer.trim());
    }

    private static void checkDotCount(int dotCount) throws SQLException {
        if (dotCount > 1) {
            throw new ParadoxSyntaxErrorException(SyntaxError.NUMBER_FORMAT);
        }
    }

    private static boolean isCharacters(char c) {
        boolean characters = false;
        if (c == '\'') {
            characters = true;
        }
        return characters;
    }

    private static boolean isSeparator(char value) {
        for (char c : SEPARATORS) {
            if (c != value) continue;
            return true;
        }
        return false;
    }

    private static boolean isSpecial(char value) {
        for (char c : SPECIAL) {
            if (c != value) continue;
            return true;
        }
        return false;
    }

    private Token getToken(String value) {
        if (value.isEmpty()) {
            return null;
        }
        TokenType token = TokenType.get(value);
        if (token != null) {
            return new Token(token, value, this.startPosition);
        }
        return new Token(TokenType.IDENTIFIER, value, this.startPosition);
    }

    private char nextChar() {
        if (!this.preloaded.isEmpty()) {
            return this.preloaded.poll().charValue();
        }
        int c = this.buffer.get();
        this.position.add((char)c);
        if (c == 92) {
            char next = this.buffer.get();
            switch (next) {
                case 'n': {
                    c = 10;
                    break;
                }
                case 'b': {
                    c = 8;
                    break;
                }
                case 'r': {
                    c = 13;
                    break;
                }
                case 't': {
                    c = 9;
                    break;
                }
                case '\\': {
                    break;
                }
                default: {
                    this.buffer.position(this.buffer.position() - 1);
                }
            }
        }
        return (char)c;
    }

    private void parseIdentifier() {
        do {
            char c;
            if (Scanner.isSeparator(c = this.nextChar())) {
                return;
            }
            if (Scanner.isSpecial(c)) {
                this.pushBack(c);
                return;
            }
            this.value.append(c);
        } while (this.hasNext());
    }

    private void parseNumber(char start) throws SQLException {
        char c = start;
        int dotCount = 0;
        do {
            this.value.append(c);
            if (c != '.') continue;
            Scanner.checkDotCount(++dotCount);
        } while (this.hasNext() && (!Scanner.isSeparator(c = this.nextChar()) && !Scanner.isSpecial(c) || c == '.'));
        if (Scanner.isSpecial(c)) {
            this.pushBack(c);
        }
    }

    private void parseString(char type) throws ParadoxSyntaxErrorException {
        char c = '\u0000';
        while (this.hasNext() && c != type) {
            c = this.nextChar();
            if (c != type) {
                this.value.append(c);
                continue;
            }
            if (!this.hasNext()) continue;
            char nextChar = this.nextChar();
            if (nextChar == type) {
                this.value.append(c);
                c = '\u0000';
                continue;
            }
            this.pushBack(nextChar);
        }
        if (c != type) {
            throw new ParadoxSyntaxErrorException(SyntaxError.UNTERMINATED_STRING, this.position);
        }
    }

    private void pushBack(char character) {
        this.preloaded.add(Character.valueOf(character));
    }

    boolean hasNext() {
        return !this.preloaded.isEmpty() || !this.tokens.isEmpty() || this.buffer.hasRemaining();
    }

    private void assertNotEmptyStatement() throws ParadoxSyntaxErrorException {
        if (!this.hasNext()) {
            throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_END_OF_STATEMENT);
        }
    }

    public Token nextToken() throws SQLException {
        int size = this.tokens.size();
        if (size > 0) {
            Token token = this.tokens.get(size - 1);
            this.tokens.remove(size - 1);
            return token;
        }
        this.assertNotEmptyStatement();
        this.value.delete(0, this.value.length());
        char c = this.nextNonSeparatorChar();
        Token ret = null;
        if (c == '\"' || c == '\'') {
            ret = this.parseIdentifier(c);
        } else if (c == '/') {
            char nextChar = this.nextChar();
            if (nextChar == '*') {
                this.parseMultilineComment();
                ret = this.nextToken();
            } else {
                this.pushBack(nextChar);
            }
        } else if (Character.isDigit(c)) {
            this.parseNumber(c);
            ret = new Token(TokenType.NUMERIC, this.value.toString(), this.startPosition);
        } else if (c == '-') {
            ret = this.parseMinusSign(c);
        } else if (Scanner.isSpecial(c)) {
            ret = this.getToken(Character.toString(c));
        }
        if (ret == null) {
            this.pushBack(c);
            this.parseIdentifier();
            ret = this.getToken(this.value.toString());
        }
        return ret;
    }

    private Token parseMinusSign(char c) throws SQLException {
        char nextChar = this.nextChar();
        this.pushBack(nextChar);
        if (Character.isDigit(nextChar)) {
            this.parseNumber(c);
            return new Token(TokenType.NUMERIC, this.value.toString(), this.startPosition);
        }
        if (nextChar == '-') {
            this.parseComment();
            return this.nextToken();
        }
        return this.getToken(Character.toString(c));
    }

    private void parseComment() {
        char c;
        do {
            c = this.nextChar();
        } while (this.hasNext() && c != '\n');
    }

    private void parseMultilineComment() {
        char last;
        char c = '\u0000';
        do {
            last = c;
            c = this.nextChar();
        } while (this.hasNext() && (last != '*' || c != '/'));
    }

    private Token parseIdentifier(char c) throws ParadoxSyntaxErrorException {
        boolean characters = Scanner.isCharacters(c);
        this.parseString(c);
        if (characters) {
            return new Token(TokenType.CHARACTER, this.value.toString(), this.startPosition);
        }
        return new Token(TokenType.IDENTIFIER, this.value.toString(), this.startPosition);
    }

    private char nextNonSeparatorChar() {
        char c;
        while (Scanner.isSeparator(c = this.nextChar())) {
        }
        this.startPosition = this.position.lastPosition();
        return c;
    }

    public void pushBack(Token token) {
        this.tokens.add(token);
    }
}

