/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.parser;

import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.FunctionFactory;
import com.googlecode.paradox.function.string.TrimFunction;
import com.googlecode.paradox.parser.Scanner;
import com.googlecode.paradox.parser.ScannerPosition;
import com.googlecode.paradox.parser.Token;
import com.googlecode.paradox.parser.TokenType;
import com.googlecode.paradox.parser.nodes.AbstractConditionalNode;
import com.googlecode.paradox.parser.nodes.AsteriskNode;
import com.googlecode.paradox.parser.nodes.JoinNode;
import com.googlecode.paradox.parser.nodes.JoinType;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.parser.nodes.SelectNode;
import com.googlecode.paradox.parser.nodes.StatementNode;
import com.googlecode.paradox.parser.nodes.TableNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.planner.nodes.FunctionNode;
import com.googlecode.paradox.planner.nodes.ParameterNode;
import com.googlecode.paradox.planner.nodes.ValueNode;
import com.googlecode.paradox.planner.nodes.comparable.AbstractComparableNode;
import com.googlecode.paradox.planner.nodes.comparable.BetweenNode;
import com.googlecode.paradox.planner.nodes.comparable.EqualsNode;
import com.googlecode.paradox.planner.nodes.comparable.GreaterThanNode;
import com.googlecode.paradox.planner.nodes.comparable.GreaterThanOrEqualsNode;
import com.googlecode.paradox.planner.nodes.comparable.ILikeNode;
import com.googlecode.paradox.planner.nodes.comparable.InNode;
import com.googlecode.paradox.planner.nodes.comparable.IsNotNullNode;
import com.googlecode.paradox.planner.nodes.comparable.IsNullNode;
import com.googlecode.paradox.planner.nodes.comparable.LessThanNode;
import com.googlecode.paradox.planner.nodes.comparable.LessThanOrEqualsNode;
import com.googlecode.paradox.planner.nodes.comparable.LikeNode;
import com.googlecode.paradox.planner.nodes.comparable.NotEqualsNode;
import com.googlecode.paradox.planner.nodes.comparable.NotNode;
import com.googlecode.paradox.planner.nodes.join.ANDNode;
import com.googlecode.paradox.planner.nodes.join.ORNode;
import com.googlecode.paradox.planner.sorting.OrderType;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;

public final class SQLParser {
    private final Scanner scanner;
    private Token token;
    private int parameterCount;

    public SQLParser(String sql) throws SQLException {
        this.scanner = new Scanner(sql);
    }

    private static FunctionNode parseFunctionAlias(String functionName, ScannerPosition position) throws SQLException {
        FunctionNode functionNode = new FunctionNode(functionName, position);
        functionNode.validate(position);
        return functionNode;
    }

    public StatementNode parse() throws SQLException {
        if (!this.scanner.hasNext()) {
            throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_END_OF_STATEMENT);
        }
        this.token = this.scanner.nextToken();
        if (!this.isToken(TokenType.SELECT)) {
            throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, this.token.getPosition());
        }
        SelectNode statementNode = this.parseSelect();
        statementNode.setParameterCount(this.parameterCount);
        return statementNode;
    }

    private void expect(TokenType token) throws SQLException {
        if (this.token == null) {
            throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_END_OF_STATEMENT);
        }
        if (this.token.getType() != token) {
            throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, this.getPosition());
        }
        this.token = this.scanner.hasNext() ? this.scanner.nextToken() : null;
    }

    private void expectComma(boolean enabled) throws SQLException {
        if (enabled) {
            this.expect(TokenType.COMMA);
        }
    }

    private AsteriskNode parseAsterisk(String tableName) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.ASTERISK);
        return new AsteriskNode(tableName, position);
    }

    private BetweenNode parseBetween(FieldNode field) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.BETWEEN);
        FieldNode left = this.parseField();
        this.expect(TokenType.AND);
        FieldNode right = this.parseField();
        return new BetweenNode(field, left, right, position);
    }

    private ValueNode parseCharacter(String fieldName) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.CHARACTER);
        return new ValueNode(fieldName, position, ParadoxType.VARCHAR);
    }

    private String getFieldAlias(String fieldName) throws SQLException {
        String fieldAlias = fieldName;
        if (this.isToken(TokenType.AS)) {
            this.expect(TokenType.AS);
            fieldAlias = this.token.getValue();
            this.expect(TokenType.IDENTIFIER);
        } else if (this.isToken(TokenType.IDENTIFIER)) {
            fieldAlias = this.token.getValue();
            this.expect(TokenType.IDENTIFIER);
        }
        return fieldAlias;
    }

    private AbstractConditionalNode parseCondition() throws SQLException {
        AbstractConditionalNode ret = null;
        while (this.scanner.hasNext() && !this.token.isConditionBreak() && !this.token.isSelectBreak()) {
            ret = this.parseSubCondition(ret);
        }
        return ret;
    }

    private AbstractConditionalNode parseSubCondition(AbstractConditionalNode parent) throws SQLException {
        AbstractConditionalNode ret = parent;
        if (!this.token.isConditionBreak() && !this.token.isSelectBreak()) {
            if (ret != null && this.token.isOperator()) {
                ret = this.parseOperators(ret);
            } else if (this.isToken(TokenType.L_PAREN)) {
                this.expect(TokenType.L_PAREN);
                while (!this.isToken(TokenType.R_PAREN)) {
                    ret = this.parseSubCondition(ret);
                }
                this.expect(TokenType.R_PAREN);
            } else if (this.isToken(TokenType.NOT)) {
                ScannerPosition position = this.token.getPosition();
                this.expect(TokenType.NOT);
                NotNode node = new NotNode(position);
                node.addChild(this.parseSubCondition(null));
                if (parent == null) {
                    ret = node;
                } else {
                    parent.addChild(node);
                }
            } else {
                ret = this.parseFieldNode();
            }
        }
        return ret;
    }

    private EqualsNode parseEquals(FieldNode field) throws SQLException {
        ScannerPosition position = this.token.getPosition();
        this.expect(TokenType.EQUALS);
        FieldNode value = this.parseField();
        return new EqualsNode(field, value, position);
    }

    private FieldNode parseField() throws SQLException {
        FieldNode ret;
        String fieldName = this.token.getValue();
        ScannerPosition position = this.getPosition();
        switch (this.token.getType()) {
            case CHARACTER: {
                ret = this.parseCharacter(fieldName);
                break;
            }
            case NUMERIC: {
                ret = this.parseNumeric(fieldName);
                break;
            }
            case NULL: {
                ret = this.parseNull();
                break;
            }
            case TRUE: {
                ret = this.parseTrue(fieldName);
                break;
            }
            case FALSE: {
                ret = this.parseFalse(fieldName);
                break;
            }
            case QUESTION_MARK: {
                ret = this.parseParameter();
                break;
            }
            default: {
                ret = this.getFieldNode(fieldName, position);
            }
        }
        return ret;
    }

    private FieldNode getFieldNode(String fieldName, ScannerPosition position) throws SQLException {
        String tableName = null;
        String name = fieldName;
        this.expect(TokenType.IDENTIFIER);
        if (this.isToken(TokenType.PERIOD)) {
            this.expect(TokenType.PERIOD);
            tableName = name;
            name = this.token.getValue();
            this.expect(TokenType.IDENTIFIER);
        } else if (this.isToken(TokenType.L_PAREN)) {
            FunctionNode node = this.parseFunction(fieldName, position, false);
            if (node.isGrouping()) {
                throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_AGGREGATE_FUNCTION, position, node.getName());
            }
            return node;
        }
        return new FieldNode(tableName, name, position);
    }

    private AbstractConditionalNode parseFieldNode() throws SQLException {
        AbstractComparableNode node;
        FieldNode firstField = this.parseField();
        switch (this.token.getType()) {
            case BETWEEN: {
                node = this.parseBetween(firstField);
                break;
            }
            case EQUALS: {
                node = this.parseEquals(firstField);
                break;
            }
            case NOT_EQUALS: {
                node = this.parseNotEquals(firstField);
                break;
            }
            case LESS: {
                node = this.parseLess(firstField);
                break;
            }
            case MORE: {
                node = this.parseMore(firstField);
                break;
            }
            case IN: {
                node = this.parseIn(firstField);
                break;
            }
            case IS: {
                node = this.parseNull(firstField);
                break;
            }
            case LIKE: {
                node = this.parseLike(firstField);
                break;
            }
            case ILIKE: {
                node = this.parseILike(firstField);
                break;
            }
            case NOT: {
                node = this.parseNot(firstField);
                break;
            }
            default: {
                throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, this.token.getPosition());
            }
        }
        return node;
    }

    private void parseFields(SelectNode select, boolean enableAggregate) throws SQLException {
        boolean firstField = true;
        do {
            SQLNode node;
            this.expectComma(!firstField);
            firstField = false;
            String fieldName = this.token.getValue();
            switch (this.token.getType()) {
                case CHARACTER: {
                    node = this.parseCharacter(fieldName);
                    break;
                }
                case NUMERIC: {
                    node = this.parseNumeric(fieldName);
                    break;
                }
                case NULL: {
                    node = this.parseNull();
                    break;
                }
                case TRUE: {
                    node = this.parseTrue(fieldName);
                    break;
                }
                case FALSE: {
                    node = this.parseFalse(fieldName);
                    break;
                }
                case ASTERISK: {
                    node = this.parseAsterisk(null);
                    break;
                }
                case QUESTION_MARK: {
                    node = this.parseParameter();
                    break;
                }
                default: {
                    node = this.parseIdentifier(fieldName, enableAggregate);
                }
            }
            node.setAlias(this.getFieldAlias(node.getAlias()));
            select.addField(node);
        } while (this.scanner.hasNext() && !this.isToken(TokenType.FROM));
    }

    private String parseFields(String oldAlias) throws SQLException {
        String tableAlias = oldAlias;
        if (this.isToken(TokenType.IDENTIFIER) || this.isToken(TokenType.AS)) {
            this.testAndRemoveTokenType(TokenType.AS);
            tableAlias = this.token.getValue();
            this.expect(TokenType.IDENTIFIER);
        }
        return tableAlias;
    }

    private void parseFrom(SelectNode select) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.FROM);
        boolean firstField = true;
        while (this.token != null && !this.token.isSelectBreak()) {
            this.expectComma(!firstField);
            firstField = false;
            this.parseJoinTable(select);
        }
        if (select.getTables().isEmpty()) {
            if (this.token != null) {
                position = this.getPosition();
            } else {
                SQLParser.addOffset(position, TokenType.FROM.name().length());
            }
            throw new ParadoxSyntaxErrorException(SyntaxError.EMPTY_TABLE_LIST, position);
        }
    }

    private SQLNode parseIdentifier(String fieldName, boolean enableAggregate) throws SQLException {
        String newTableName = null;
        String newFieldName = fieldName;
        ScannerPosition position = this.getPosition();
        this.token = this.scanner.hasNext() ? this.scanner.nextToken() : null;
        if (this.isToken(TokenType.L_PAREN)) {
            return this.parseFunction(fieldName, position, enableAggregate);
        }
        if (this.isToken(TokenType.PERIOD)) {
            this.expect(TokenType.PERIOD);
            newTableName = fieldName;
            newFieldName = this.token.getValue();
            if (this.isToken(TokenType.ASTERISK)) {
                return this.parseAsterisk(newTableName);
            }
            this.expect(TokenType.IDENTIFIER);
        } else if (FunctionFactory.isFunctionAlias(fieldName)) {
            return SQLParser.parseFunctionAlias(fieldName, position);
        }
        return new FieldNode(newTableName, newFieldName, position);
    }

    private boolean isFunctionSpecific(String functionName, FunctionNode node) throws SQLException {
        boolean ret = false;
        if (functionName.equalsIgnoreCase("POSITION")) {
            this.expect(TokenType.IN);
            ret = true;
        } else if (functionName.equalsIgnoreCase("EXTRACT")) {
            this.expect(TokenType.FROM);
            ret = true;
        } else if (functionName.equalsIgnoreCase("TRIM") && this.token != null) {
            if (TrimFunction.isValidType(node.getParameters().get(0).getName())) {
                if (node.getParameters().size() == 2) {
                    this.expect(TokenType.FROM);
                } else if (node.getParameters().size() != 1) {
                    throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, this.token.getPosition(), this.token.getValue());
                }
            } else if (node.getParameters().size() == 1) {
                this.expect(TokenType.FROM);
            } else {
                throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, this.token.getPosition(), this.token.getValue());
            }
            ret = true;
        } else if (functionName.equalsIgnoreCase("SUBSTRING")) {
            if (this.isToken(TokenType.COMMA)) {
                this.expect(TokenType.COMMA);
            } else if (node.getParameters().size() == 1) {
                this.expect(TokenType.FROM);
            } else {
                this.expect(TokenType.FOR);
            }
            ret = true;
        } else if (functionName.equalsIgnoreCase("CONVERT")) {
            if (this.isToken(TokenType.USING)) {
                node.getParameters().add(new ValueNode(this.token.getValue(), this.token.getPosition(), ParadoxType.VARCHAR));
                this.expect(TokenType.USING);
            } else {
                this.expect(TokenType.COMMA);
            }
            ret = true;
        } else if (functionName.equalsIgnoreCase("CAST")) {
            this.expect(TokenType.AS);
            ret = true;
        }
        return ret;
    }

    private FunctionNode parseFunction(String functionName, ScannerPosition position, boolean enableAggregate) throws SQLException {
        FunctionNode functionNode = new FunctionNode(functionName, position);
        this.expect(TokenType.L_PAREN);
        boolean first = true;
        block9: while (!this.isToken(TokenType.R_PAREN)) {
            if (!first && !this.isFunctionSpecific(functionName, functionNode)) {
                this.expect(TokenType.COMMA);
            }
            first = false;
            switch (this.token.getType()) {
                case CHARACTER: {
                    functionNode.addParameter(this.parseCharacter(this.token.getValue()));
                    continue block9;
                }
                case NUMERIC: {
                    functionNode.addParameter(this.parseNumeric(this.token.getValue()));
                    continue block9;
                }
                case NULL: {
                    functionNode.addParameter(this.parseNull());
                    continue block9;
                }
                case TRUE: {
                    functionNode.addParameter(this.parseTrue(this.token.getValue()));
                    continue block9;
                }
                case FALSE: {
                    functionNode.addParameter(this.parseFalse(this.token.getValue()));
                    continue block9;
                }
                case ASTERISK: {
                    functionNode.addParameter(this.parseAsterisk(null));
                    continue block9;
                }
                case QUESTION_MARK: {
                    functionNode.addParameter(this.parseParameter());
                    continue block9;
                }
            }
            functionNode.addParameter(this.parseIdentifierFieldFunction(this.token.getValue(), enableAggregate));
        }
        ScannerPosition endPosition = this.getPosition();
        this.expect(TokenType.R_PAREN);
        functionNode.validate(endPosition);
        return functionNode;
    }

    private ParameterNode parseParameter() throws SQLException {
        ScannerPosition position = this.token.getPosition();
        this.expect(TokenType.QUESTION_MARK);
        ParameterNode node = new ParameterNode(this.parameterCount, position);
        ++this.parameterCount;
        return node;
    }

    private FieldNode parseIdentifierFieldFunction(String fieldName, boolean enableAggregate) throws SQLException {
        String newTableName = null;
        String newFieldName = fieldName;
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.IDENTIFIER);
        if (this.isToken(TokenType.L_PAREN)) {
            FunctionNode node = this.parseFunction(fieldName, position, enableAggregate);
            if (node.isGrouping() && !enableAggregate) {
                throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_AGGREGATE_FUNCTION, position, node.getName());
            }
            return node;
        }
        if (this.isToken(TokenType.PERIOD)) {
            this.expect(TokenType.PERIOD);
            newTableName = fieldName;
            newFieldName = this.token.getValue();
            this.expect(TokenType.IDENTIFIER);
        } else if (FunctionFactory.isFunctionAlias(fieldName)) {
            return SQLParser.parseFunctionAlias(fieldName, position);
        }
        return new FieldNode(newTableName, newFieldName, position);
    }

    private void parseJoin(SelectNode select) throws SQLException {
        while (this.scanner.hasNext() && !this.isToken(TokenType.COMMA) && !this.token.isSelectBreak()) {
            JoinType joinType = this.getJoinType();
            this.expect(TokenType.JOIN);
            String schemaName = null;
            String tableName = this.token.getValue();
            this.expect(TokenType.IDENTIFIER);
            if (this.isToken(TokenType.PERIOD)) {
                this.expect(TokenType.PERIOD);
                schemaName = tableName;
                tableName = this.token.getValue();
                this.expect(TokenType.IDENTIFIER);
            }
            String tableAlias = this.parseFields(tableName);
            JoinNode joinTable = new JoinNode(schemaName, tableName, tableAlias, joinType, null);
            if (joinType != JoinType.CROSS) {
                this.expect(TokenType.ON);
                joinTable.setCondition(this.parseCondition());
            }
            select.addTable(joinTable);
        }
    }

    private JoinType getJoinType() throws SQLException {
        JoinType joinType = JoinType.INNER;
        switch (this.token.getType()) {
            case FULL: {
                joinType = JoinType.FULL;
                this.expect(TokenType.FULL);
                this.testAndRemoveTokenType(TokenType.OUTER);
                break;
            }
            case LEFT: {
                joinType = JoinType.LEFT;
                this.expect(TokenType.LEFT);
                this.testAndRemoveTokenType(TokenType.OUTER);
                break;
            }
            case RIGHT: {
                joinType = JoinType.RIGHT;
                this.expect(TokenType.RIGHT);
                this.testAndRemoveTokenType(TokenType.OUTER);
                break;
            }
            case CROSS: {
                joinType = JoinType.CROSS;
                this.expect(TokenType.CROSS);
                break;
            }
            case INNER: {
                this.expect(TokenType.INNER);
                break;
            }
        }
        return joinType;
    }

    private void testAndRemoveTokenType(TokenType token) throws SQLException {
        if (this.isToken(token)) {
            this.expect(token);
        }
    }

    private void parseJoinTable(SelectNode select) throws SQLException {
        String schemaName = null;
        String tableName = this.token.getValue();
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.IDENTIFIER);
        if (this.isToken(TokenType.PERIOD)) {
            this.expect(TokenType.PERIOD);
            schemaName = tableName;
            tableName = this.token.getValue();
            this.expect(TokenType.IDENTIFIER);
        }
        String tableAlias = this.parseFields(tableName);
        TableNode table = new TableNode(schemaName, tableName, tableAlias, position);
        select.addTable(table);
        this.parseJoin(select);
    }

    private AbstractComparableNode parseLess(FieldNode firstField) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.LESS);
        if (this.isToken(TokenType.EQUALS)) {
            this.expect(TokenType.EQUALS);
            return new LessThanOrEqualsNode(firstField, this.parseField(), position);
        }
        return new LessThanNode(firstField, this.parseField(), position);
    }

    private AbstractComparableNode parseMore(FieldNode firstField) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.MORE);
        if (this.isToken(TokenType.EQUALS)) {
            this.expect(TokenType.EQUALS);
            return new GreaterThanOrEqualsNode(firstField, this.parseField(), position);
        }
        return new GreaterThanNode(firstField, this.parseField(), position);
    }

    private InNode parseIn(FieldNode firstField) throws SQLException {
        ScannerPosition position = this.token.getPosition();
        this.expect(TokenType.IN);
        this.expect(TokenType.L_PAREN);
        InNode in = new InNode(firstField, position);
        boolean first = true;
        do {
            this.expectComma(!first);
            first = false;
            if (this.isToken(TokenType.NUMERIC)) {
                in.addField(new ValueNode(this.token.getValue(), this.token.getPosition(), ParadoxType.NUMBER));
                this.expect(TokenType.NUMERIC);
                continue;
            }
            if (this.isToken(TokenType.CHARACTER)) {
                in.addField(new ValueNode(this.token.getValue(), this.token.getPosition(), ParadoxType.VARCHAR));
                this.expect(TokenType.CHARACTER);
                continue;
            }
            throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, this.getPosition());
        } while (!this.isToken(TokenType.R_PAREN));
        this.expect(TokenType.R_PAREN);
        return in;
    }

    private AbstractComparableNode parseNull(FieldNode firstField) throws SQLException {
        AbstractComparableNode ret;
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.IS);
        if (this.isToken(TokenType.NOT)) {
            this.expect(TokenType.NOT);
            ret = new IsNotNullNode(firstField, position);
        } else {
            ret = new IsNullNode(firstField, position);
        }
        this.expect(TokenType.NULL);
        return ret;
    }

    private NotNode parseNot(FieldNode firstField) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.NOT);
        NotNode not = new NotNode(position);
        if (this.isToken(TokenType.LIKE)) {
            not.addChild(this.parseLike(firstField));
        } else if (this.isToken(TokenType.ILIKE)) {
            not.addChild(this.parseILike(firstField));
        } else if (this.isToken(TokenType.IN)) {
            not.addChild(this.parseIn(firstField));
        } else {
            throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, this.getPosition());
        }
        return not;
    }

    private LikeNode parseLike(FieldNode firstField) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.LIKE);
        LikeNode like = new LikeNode(firstField, this.parseField(), position);
        this.parseEscapeToken(like);
        return like;
    }

    private ILikeNode parseILike(FieldNode firstField) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.ILIKE);
        ILikeNode iLikeNode = new ILikeNode(firstField, this.parseField(), position);
        this.parseEscapeToken(iLikeNode);
        return iLikeNode;
    }

    private void parseEscapeToken(LikeNode likeNode) throws SQLException {
        if (this.isToken(TokenType.ESCAPE)) {
            this.expect(TokenType.ESCAPE);
            FieldNode field = this.parseField();
            if (field instanceof ValueNode) {
                ValueNode value = (ValueNode)field;
                if (value.getType() != ParadoxType.VARCHAR || value.getName().length() != 1) {
                    throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_CHAR);
                }
                likeNode.setEscape(value.getName().charAt(0));
            } else {
                throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_CHAR);
            }
        }
    }

    private NotEqualsNode parseNotEquals(FieldNode firstField) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.NOT_EQUALS);
        FieldNode value = this.parseField();
        return new NotEqualsNode(firstField, value, position);
    }

    private ValueNode parseNumeric(String fieldName) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.NUMERIC);
        return new ValueNode(fieldName, position, ParadoxType.NUMBER);
    }

    private ValueNode parseTrue(String fieldName) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.TRUE);
        ValueNode value = new ValueNode("true", position, ParadoxType.BOOLEAN);
        value.setAlias(fieldName);
        return value;
    }

    private ValueNode parseFalse(String fieldName) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.FALSE);
        ValueNode value = new ValueNode("false", position, ParadoxType.BOOLEAN);
        value.setAlias(fieldName);
        return value;
    }

    private ValueNode parseNull() throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.NULL);
        ValueNode value = new ValueNode(null, position, ParadoxType.NULL);
        value.setAlias("null");
        return value;
    }

    private AbstractConditionalNode parseOperators(AbstractConditionalNode parent) throws SQLException {
        AbstractConditionalNode ret;
        ScannerPosition position = this.getPosition();
        if (this.isToken(TokenType.AND)) {
            this.expect(TokenType.AND);
            ret = parent instanceof ANDNode ? parent : new ANDNode(parent, position);
            ret.addChild(this.parseSubCondition(null));
        } else {
            this.expect(TokenType.OR);
            ret = parent instanceof ORNode ? parent : new ORNode(parent, position);
            ret.addChild(this.parseSubCondition(null));
        }
        return ret;
    }

    private void parseOrderBy(SelectNode select) throws SQLException {
        this.expect(TokenType.ORDER);
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.BY);
        if (this.token == null) {
            SQLParser.addOffset(position, TokenType.BY.name().length());
            throw new ParadoxSyntaxErrorException(SyntaxError.EMPTY_COLUMN_LIST, position);
        }
        boolean firstField = true;
        while (this.token != null && !this.token.isSelectBreak()) {
            FieldNode fieldNode;
            this.expectComma(!firstField);
            firstField = false;
            String fieldName = this.token.getValue();
            position = this.getPosition();
            if (this.token.getType() == TokenType.NUMERIC) {
                fieldNode = this.parseNumeric(fieldName);
            } else if (this.token.getType() == TokenType.IDENTIFIER) {
                fieldNode = this.parseIdentifierFieldFunction(fieldName, true);
            } else {
                throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, position);
            }
            OrderType type = this.getOrderType();
            select.addOrderBy(fieldNode, type);
        }
    }

    private OrderType getOrderType() throws SQLException {
        OrderType type = OrderType.ASC;
        if (this.isToken(TokenType.ASC)) {
            this.expect(TokenType.ASC);
        } else if (this.isToken(TokenType.DESC)) {
            this.expect(TokenType.DESC);
            type = OrderType.DESC;
        }
        return type;
    }

    private void parseGroupBy(SelectNode select) throws SQLException {
        this.expect(TokenType.GROUP);
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.BY);
        if (this.token == null) {
            SQLParser.addOffset(position, TokenType.BY.name().length());
            throw new ParadoxSyntaxErrorException(SyntaxError.EMPTY_COLUMN_LIST, position);
        }
        boolean firstField = true;
        while (this.token != null && !this.token.isConditionBreak()) {
            FieldNode fieldNode;
            this.expectComma(!firstField);
            firstField = false;
            String fieldName = this.token.getValue();
            position = this.getPosition();
            if (this.isToken(TokenType.NUMERIC)) {
                fieldNode = this.parseNumeric(fieldName);
            } else if (this.isToken(TokenType.CHARACTER)) {
                fieldNode = this.parseCharacter(fieldName);
            } else if (this.isToken(TokenType.NULL)) {
                fieldNode = this.parseNull();
            } else if (this.isToken(TokenType.TRUE)) {
                fieldNode = this.parseTrue(this.token.getValue());
            } else if (this.isToken(TokenType.FALSE)) {
                fieldNode = this.parseFalse(this.token.getValue());
            } else if (this.isToken(TokenType.IDENTIFIER)) {
                fieldNode = this.parseIdentifierFieldFunction(fieldName, false);
            } else {
                throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, position);
            }
            select.addGroupBy(fieldNode);
        }
    }

    private SelectNode parseSelect() throws SQLException {
        ScannerPosition position = this.getPosition();
        SelectNode select = new SelectNode(position);
        this.expect(TokenType.SELECT);
        if (this.isToken(TokenType.DISTINCT)) {
            select.setDistinct(true);
            this.expect(TokenType.DISTINCT);
        }
        if (this.token != null) {
            this.parseFields(select, true);
        }
        if (select.getFields().isEmpty()) {
            SQLParser.addOffset(position, TokenType.SELECT.name().length());
            throw new ParadoxSyntaxErrorException(SyntaxError.EMPTY_COLUMN_LIST, position);
        }
        if (this.isToken(TokenType.FROM)) {
            this.parseFrom(select);
            if (this.isToken(TokenType.WHERE)) {
                this.parseWhere(select);
            }
            if (this.isToken(TokenType.GROUP)) {
                this.parseGroupBy(select);
            }
            if (this.isToken(TokenType.ORDER)) {
                this.parseOrderBy(select);
            }
        }
        if (this.isToken(TokenType.LIMIT)) {
            this.parseLimit(select);
        }
        if (this.isToken(TokenType.OFFSET)) {
            this.parseOffset(select);
        }
        if (this.scanner.hasNext() || this.token != null) {
            throw new ParadoxSyntaxErrorException(SyntaxError.UNEXPECTED_TOKEN, this.token.getPosition());
        }
        return select;
    }

    private void parseLimit(SelectNode select) throws SQLException {
        this.expect(TokenType.LIMIT);
        select.setLimit(Integer.valueOf(this.token.getValue()));
        if (select.getLimit() < 0) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, this.token.getPosition(), this.token.getValue());
        }
        this.expect(TokenType.NUMERIC);
    }

    private void parseOffset(SelectNode select) throws SQLException {
        this.expect(TokenType.OFFSET);
        select.setOffset(Integer.valueOf(this.token.getValue()));
        if (select.getOffset() < 0) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, this.token.getPosition(), this.token.getValue());
        }
        this.expect(TokenType.NUMERIC);
    }

    private void parseWhere(SelectNode select) throws SQLException {
        ScannerPosition position = this.getPosition();
        this.expect(TokenType.WHERE);
        select.setCondition(this.parseCondition());
        if (select.getCondition() == null) {
            SQLParser.addOffset(position, TokenType.WHERE.name().length());
            throw new ParadoxSyntaxErrorException(SyntaxError.EMPTY_CONDITIONAL_LIST, position);
        }
    }

    private boolean isToken(TokenType type) {
        return this.token != null && this.token.getType() == type;
    }

    private ScannerPosition getPosition() {
        if (this.token != null) {
            return this.token.getPosition();
        }
        return null;
    }

    private static void addOffset(ScannerPosition position, int offset) {
        if (position != null) {
            position.addOffset(offset);
        }
    }
}

