/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Warnings
implements Table {
    private static final Logger LOGGER = Logger.getLogger(Warnings.class.getName());
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field reason = new Field("reason", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field sqlState = new Field("sql_state", 0, 10, ParadoxType.VARCHAR, this, 3);
    private final Field vendorCode = new Field("vendor_code", 0, 0, ParadoxType.INTEGER, this, 4);
    private final Field stackTrace = new Field("stackTrace", 0, 0, ParadoxType.MEMO, this, 5);

    public Warnings(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_warnings";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.reason, this.sqlState, this.vendorCode, this.stackTrace};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        int sum = 0;
        for (SQLWarning warning = this.connectionInfo.getWarning(); warning != null; warning = warning.getNextWarning()) {
            ++sum;
        }
        return sum;
    }

    @Override
    public List<Object[]> load(Field[] fields) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (SQLWarning warning = this.connectionInfo.getWarning(); warning != null; warning = warning.getNextWarning()) {
            Object[] row = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                Object value = null;
                if (this.catalog.equals(field)) {
                    value = this.catalogName;
                } else if (this.reason.equals(field)) {
                    value = warning.getMessage();
                } else if (this.sqlState.equals(field)) {
                    value = warning.getSQLState();
                } else if (this.vendorCode.equals(field)) {
                    value = warning.getErrorCode();
                } else if (this.stackTrace.equals(field)) {
                    value = Warnings.printStack(warning);
                }
                row[i] = value;
            }
            ret.add(row);
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    private static String printStack(SQLWarning warning) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

