/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.IndexType;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.SoftIndex;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.metadata.View;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Views
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field name = new Field("name", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field definition = new Field("definition", 0, 0, ParadoxType.VARCHAR, this, 4);
    private final Field check = new Field("check_option", 0, 7, ParadoxType.VARCHAR, this, 5);
    private final Field updatable = new Field("is_updatable", 0, 2, ParadoxType.VARCHAR, this, 6);

    public Views(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_views";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index[] getIndexes() {
        return new Index[]{new SoftIndex("views.pk", true, new Field[]{this.catalog, this.schema, this.name}, IndexType.PRIMARY_KEY, this::getRowCount)};
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.name, this.definition, this.check, this.updatable};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            int sum = 0;
            for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
                for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                    if (!(localTable instanceof View)) continue;
                    sum += localTable.getFields().length;
                }
            }
            return sum;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            for (Table table : localSchema.list(this.connectionInfo, null)) {
                if (!(table instanceof View)) continue;
                Object[] row = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    String value = null;
                    if (this.catalog.equals(field)) {
                        value = localSchema.catalogName();
                    } else if (this.schema.equals(field)) {
                        value = localSchema.name();
                    } else if (this.name.equals(field)) {
                        value = table.getName();
                    } else if (this.definition.equals(field)) {
                        value = ((View)table).definition();
                    } else if (this.check.equals(field)) {
                        value = "NONE";
                    } else if (this.updatable.equals(field)) {
                        value = "NO";
                    }
                    row[i] = value;
                }
                ret.add(row);
            }
        }
        return ret;
    }
}

