/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.metadata.View;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ViewColumnUsage
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field name = new Field("name", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field tableCatalog = new Field("table_catalog", 0, 0, ParadoxType.VARCHAR, this, 4);
    private final Field tableSchema = new Field("table_schema", 0, 7, ParadoxType.VARCHAR, this, 5);
    private final Field tableName = new Field("table_name", 0, 2, ParadoxType.VARCHAR, this, 6);
    private final Field columnName = new Field("column_name", 0, 2, ParadoxType.VARCHAR, this, 7);

    public ViewColumnUsage(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_view_column_usage";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.name, this.tableCatalog, this.tableSchema, this.tableName, this.columnName};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            int sum = 0;
            for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
                sum += (int)localSchema.list(this.connectionInfo, null).stream().filter(table -> table instanceof View).count();
            }
            return sum;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            for (Table table : localSchema.list(this.connectionInfo, null)) {
                if (!(table instanceof View)) continue;
                for (Field usageField : ((View)table).usages()) {
                    Object[] row = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        String value = null;
                        if (this.catalog.equals(field)) {
                            value = localSchema.catalogName();
                        } else if (this.schema.equals(field)) {
                            value = localSchema.name();
                        } else if (this.name.equals(field)) {
                            value = table.getName();
                        } else if (this.tableCatalog.equals(field)) {
                            value = localSchema.catalogName();
                        } else if (this.tableSchema.equals(field)) {
                            value = usageField.getTable().getSchemaName();
                        } else if (this.tableName.equals(field)) {
                            value = usageField.getTable().getName();
                        } else if (this.columnName.equals(field)) {
                            value = usageField.getName();
                        }
                        row[i] = value;
                    }
                    ret.add(row);
                }
            }
        }
        return ret;
    }
}

