/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.IndexType;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.SoftIndex;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Tables
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field name = new Field("name", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field type = new Field("type", 0, 10, ParadoxType.VARCHAR, this, 4);
    private final Field typeName = new Field("type_name", 0, 10, ParadoxType.VARCHAR, this, 5);
    private final Field charset = new Field("charset", 0, 0, ParadoxType.VARCHAR, this, 6);
    private final Field encrypted = new Field("encrypted", 0, 3, ParadoxType.VARCHAR, this, 7);
    private final Field writeProtected = new Field("write_protected", 0, 3, ParadoxType.VARCHAR, this, 8);
    private final Field count = new Field("count", 0, 0, ParadoxType.VARCHAR, this, 9);
    private final Field blockSize = new Field("block_size", 0, 2, ParadoxType.INTEGER, this, 10);
    private final Field totalBlocks = new Field("total_blocks", 0, 2, ParadoxType.INTEGER, this, 11);
    private final Field usedBlocks = new Field("used_blocks", 0, 2, ParadoxType.INTEGER, this, 12);
    private final Field freeBlocks = new Field("free_blocks", 0, 2, ParadoxType.INTEGER, this, 13);
    private final Field recordSize = new Field("record_size", 0, 2, ParadoxType.INTEGER, this, 14);

    public Tables(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_tables";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index[] getIndexes() {
        return new Index[]{new SoftIndex("tables.pk", true, new Field[]{this.catalog, this.schema, this.name, this.type}, IndexType.PRIMARY_KEY, this::getRowCount)};
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.name, this.type, this.typeName, this.charset, this.encrypted, this.writeProtected, this.count, this.blockSize, this.totalBlocks, this.usedBlocks, this.freeBlocks, this.recordSize};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            int sum = 0;
            for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
                sum += localSchema.list(this.connectionInfo, null).size();
            }
            return sum;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            for (Table table : localSchema.list(this.connectionInfo, null)) {
                Object[] row = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    Object value = null;
                    if (this.catalog.equals(field)) {
                        value = localSchema.catalogName();
                    } else if (this.schema.equals(field)) {
                        value = localSchema.name();
                    } else if (this.name.equals(field)) {
                        value = table.getName();
                    } else if (this.type.equals(field)) {
                        value = table.type().description();
                    } else if (this.typeName.equals(field)) {
                        value = table.type().typeName();
                    } else if (this.charset.equals(field) && table.getCharset() != null) {
                        value = table.getCharset().displayName();
                    } else if (this.encrypted.equals(field)) {
                        value = this.description(table.isEncrypted());
                    } else if (this.writeProtected.equals(field)) {
                        value = this.description(table.isWriteProtected());
                    } else if (this.count.equals(field) && table.getCharset() != null) {
                        value = table.getRowCount();
                    } else if (this.blockSize.equals(field)) {
                        value = table.getBlockSizeBytes();
                    } else if (this.totalBlocks.equals(field)) {
                        value = table.getTotalBlocks();
                    } else if (this.usedBlocks.equals(field)) {
                        value = table.getUsedBlocks();
                    } else if (this.freeBlocks.equals(field)) {
                        value = table.getTotalBlocks() - table.getUsedBlocks();
                    } else if (this.recordSize.equals(field)) {
                        value = table.getRecordSize();
                    }
                    row[i] = value;
                }
                ret.add(row);
            }
        }
        return ret;
    }
}

