/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TableConstraints
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field table = new Field("table", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field name = new Field("name", 0, 255, ParadoxType.VARCHAR, this, 4);
    private final Field type = new Field("type", 0, 11, ParadoxType.VARCHAR, this, 5);
    private final Field isDeferrable = new Field("is_deferrable", 0, 2, ParadoxType.VARCHAR, this, 6);
    private final Field initiallyDeferred = new Field("initially_deferred", 0, 2, ParadoxType.VARCHAR, this, 7);

    public TableConstraints(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_table_constraints";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.table, this.name, this.type, this.isDeferrable, this.initiallyDeferred};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            int sum = 0;
            for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
                for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                    sum += localTable.getConstraints().length;
                }
            }
            return sum;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                for (Index index : localTable.getConstraints()) {
                    Object[] row = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        String value = null;
                        if (this.catalog.equals(field)) {
                            value = localSchema.catalogName();
                        } else if (this.schema.equals(field)) {
                            value = localSchema.name();
                        } else if (this.table.equals(field)) {
                            value = localTable.getName();
                        } else if (this.name.equals(field)) {
                            value = index.getName();
                        } else if (this.type.equals(field)) {
                            value = index.type().description();
                        } else if (this.isDeferrable.equals(field)) {
                            value = "NO";
                        } else if (this.initiallyDeferred.equals(field)) {
                            value = "NO";
                        }
                        row[i] = value;
                    }
                    ret.add(row);
                }
            }
        }
        return ret;
    }
}

