/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.IndexType;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.SoftIndex;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Schemata
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("catalog_name", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("schema_name", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field owner = new Field("schema_owner", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field characterCatalog = new Field("default_character_set_catalog", 0, 6, ParadoxType.VARCHAR, this, 4);
    private final Field characterSchema = new Field("default_character_set_schema", 0, 3, ParadoxType.VARCHAR, this, 5);
    private final Field characterName = new Field("default_character_set_name", 0, 6, ParadoxType.VARCHAR, this, 6);

    public Schemata(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_schemata";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index[] getIndexes() {
        return new Index[]{new SoftIndex("schemata.pk", true, new Field[]{this.catalog, this.schema}, IndexType.PRIMARY_KEY, this::getRowCount)};
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.owner, this.characterCatalog, this.characterSchema, this.characterName};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            return this.connectionInfo.getSchemas(this.catalogName, null).size();
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema currentSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            Object[] row = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                String value = null;
                if (this.catalog.equals(field)) {
                    value = currentSchema.catalogName();
                } else if (this.schema.equals(field)) {
                    value = currentSchema.name();
                } else if (this.owner.equals(field)) {
                    value = this.connectionInfo.getUser();
                } else if (this.characterName.equals(field) && this.connectionInfo.getCharset() != null) {
                    value = this.connectionInfo.getCharset().displayName();
                }
                row[i] = value;
            }
            ret.add(row);
        }
        return ret;
    }
}

