/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.AbstractFunction;
import com.googlecode.paradox.function.FunctionFactory;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.IndexType;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.SoftIndex;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class Routines
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field name = new Field("name", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field type = new Field("type", 0, 10, ParadoxType.VARCHAR, this, 4);
    private final Field dataType = new Field("data_type", 0, 0, ParadoxType.VARCHAR, this, 4);
    private final Field maximumLength = new Field("character_maximum_length", 0, 10, ParadoxType.VARCHAR, this, 5);
    private final Field octetLength = new Field("character_octet_length", 0, 0, ParadoxType.VARCHAR, this, 6);
    private final Field precision = new Field("precision", 0, 4, ParadoxType.INTEGER, this, 7);
    private final Field scale = new Field("scale", 0, 4, ParadoxType.INTEGER, this, 8);
    private final Field radix = new Field("numeric_precision_radix", 0, 4, ParadoxType.INTEGER, this, 9);
    private final Field body = new Field("routine_body", 0, 0, ParadoxType.VARCHAR, this, 10);
    private final Field definition = new Field("routine_definition", 0, 0, ParadoxType.VARCHAR, this, 11);
    private final Field isDeterministic = new Field("is_deterministic", 0, 3, ParadoxType.VARCHAR, this, 12);
    private final Field sqlDataAccess = new Field("sql_data_access", 0, 30, ParadoxType.VARCHAR, this, 13);
    private final Field isNullCall = new Field("is_null_call", 0, 3, ParadoxType.VARCHAR, this, 14);
    private final Field isImplicitly = new Field("is_implicitly_invocable", 0, 3, ParadoxType.VARCHAR, this, 14);
    private final Field remarks = new Field("remarks", 0, 0, ParadoxType.VARCHAR, this, 15);

    public Routines(ConnectionInfo connectionInfo, String catalogName) {
        this.connectionInfo = connectionInfo;
        this.catalogName = catalogName;
    }

    @Override
    public String getName() {
        return "pdx_routines";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index[] getIndexes() {
        return new Index[]{new SoftIndex("routines.pk", true, new Field[]{this.catalog, this.schema, this.name, this.type}, IndexType.PRIMARY_KEY, this::getRowCount)};
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.name, this.type, this.dataType, this.maximumLength, this.octetLength, this.precision, this.scale, this.radix, this.body, this.definition, this.isDeterministic, this.sqlDataAccess, this.isNullCall, this.isImplicitly, this.remarks};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            return this.connectionInfo.getSchemas(this.catalogName, null).stream().mapToInt(localSchema -> FunctionFactory.getFunctions().size()).sum();
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            for (Map.Entry<String, Supplier<? extends AbstractFunction>> entry : FunctionFactory.getFunctions().entrySet()) {
                AbstractFunction function = entry.getValue().get();
                Object[] row = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    String value = null;
                    if (this.catalog.equals(field)) {
                        value = this.catalogName;
                    } else if (this.schema.equals(field)) {
                        value = localSchema.name();
                    } else if (this.name.equals(field)) {
                        value = entry.getKey();
                    } else if (this.type.equals(field)) {
                        value = "FUNCTION";
                    } else if (this.dataType.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getType).map(Enum::name).findFirst().orElse(null);
                    } else if (this.maximumLength.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getSize).findFirst().orElse(null);
                    } else if (this.octetLength.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getOctets).findFirst().orElse(null);
                    } else if (this.scale.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getScale).findFirst().orElse(null);
                    } else if (this.precision.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getPrecision).findFirst().orElse(null);
                    } else if (this.radix.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getRadix).filter(Objects::nonNull).findFirst().orElse(null);
                    } else if (this.body.equals(field)) {
                        value = "EXTERNAL";
                    } else if (this.definition.equals(field)) {
                        value = function.definition();
                    } else if (this.isDeterministic.equals(field)) {
                        value = function.isDeterministic() ? "YES" : "NO";
                    } else if (this.sqlDataAccess.equals(field)) {
                        value = "READS";
                    } else if (this.isNullCall.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() != 5).anyMatch(Column::isNullable) ? "NO" : "YES";
                    } else if (this.isImplicitly.equals(field)) {
                        value = "NO";
                    } else if (this.remarks.equals(field)) {
                        value = function.getRemarks();
                    }
                    row[i] = value;
                }
                ret.add(row);
            }
        }
        return ret;
    }
}

