/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.function.AbstractFunction;
import com.googlecode.paradox.function.FunctionFactory;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public class Parameters
implements Table {
    private final String catalogName;
    private final Field catalog = new Field("catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field routine = new Field("routine", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field ordinal = new Field("ordinal", 0, 0, ParadoxType.INTEGER, this, 4);
    private final Field mode = new Field("mode", 0, 3, ParadoxType.VARCHAR, this, 5);
    private final Field isResult = new Field("is_result", 0, 3, ParadoxType.VARCHAR, this, 6);
    private final Field name = new Field("name", 0, 255, ParadoxType.VARCHAR, this, 7);
    private final Field dataType = new Field("data_type", 0, 0, ParadoxType.VARCHAR, this, 8);
    private final Field maximumLength = new Field("character_maximum_length", 0, 10, ParadoxType.VARCHAR, this, 9);
    private final Field octetLength = new Field("character_octet_length", 0, 0, ParadoxType.VARCHAR, this, 10);
    private final Field precision = new Field("precision", 0, 4, ParadoxType.INTEGER, this, 11);
    private final Field scale = new Field("scale", 0, 4, ParadoxType.INTEGER, this, 12);
    private final Field radix = new Field("numeric_precision_radix", 0, 4, ParadoxType.INTEGER, this, 13);
    private final Field remarks = new Field("remarks", 0, 4, ParadoxType.VARCHAR, this, 14);

    public Parameters(String catalogName) {
        this.catalogName = catalogName;
    }

    @Override
    public String getName() {
        return "pdx_routine_parameters";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.routine, this.ordinal, this.mode, this.isResult, this.name, this.dataType, this.maximumLength, this.octetLength, this.precision, this.scale, this.radix, this.remarks};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        int sum = 0;
        for (Map.Entry<String, Supplier<? extends AbstractFunction>> entry : FunctionFactory.getFunctions().entrySet()) {
            AbstractFunction function = entry.getValue().get();
            sum += function.getColumns().length;
        }
        return sum;
    }

    @Override
    public List<Object[]> load(Field[] fields) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Map.Entry<String, Supplier<? extends AbstractFunction>> entry : FunctionFactory.getFunctions().entrySet()) {
            AbstractFunction function = entry.getValue().get();
            for (Column column : function.getColumns()) {
                Object[] row = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    Object value = null;
                    if (this.catalog.equals(field)) {
                        value = this.catalogName;
                    } else if (this.schema.equals(field)) {
                        value = this.getSchemaName();
                    } else if (this.routine.equals(field)) {
                        value = entry.getKey();
                    } else if (this.ordinal.equals(field)) {
                        value = column.getIndex();
                    } else if (this.mode.equals(field)) {
                        if (column.getColumnType() == 1) {
                            value = "IN";
                        } else if (column.getColumnType() == 5) {
                            value = "OUT";
                        }
                    } else if (this.isResult.equals(field)) {
                        value = 5 == column.getColumnType() ? "YES" : "NO";
                    } else if (this.name.equals(field)) {
                        value = column.getName();
                    } else if (this.dataType.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getType).map(Enum::name).findFirst().orElse(null);
                    } else if (this.maximumLength.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getSize).findFirst().orElse(null);
                    } else if (this.octetLength.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getOctets).findFirst().orElse(null);
                    } else if (this.scale.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getScale).findFirst().orElse(null);
                    } else if (this.precision.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getPrecision).findFirst().orElse(null);
                    } else if (this.radix.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getRadix).filter(Objects::nonNull).findFirst().orElse(null);
                    } else if (this.remarks.equals(field)) {
                        value = Arrays.stream(function.getColumns()).filter(c -> c.getColumnType() == 5).map(Column::getRemarks).filter(Objects::nonNull).findFirst().orElse(null);
                    }
                    row[i] = value;
                }
                ret.add(row);
            }
        }
        return ret;
    }
}

