/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.IndexType;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.SoftIndex;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class KeyColumns
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field table = new Field("table", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field constraintName = new Field("constraint_name", 0, 255, ParadoxType.VARCHAR, this, 4);
    private final Field name = new Field("name", 0, 255, ParadoxType.VARCHAR, this, 5);
    private final Field ordinal = new Field("ordinal", 0, 4, ParadoxType.INTEGER, this, 6);

    public KeyColumns(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_key_columns";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index[] getIndexes() {
        return new Index[]{new SoftIndex("key_columns.pk", true, new Field[]{this.catalog, this.schema, this.table, this.constraintName, this.name}, IndexType.PRIMARY_KEY, this::getRowCount)};
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.table, this.constraintName, this.name, this.ordinal};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            int sum = 0;
            for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
                for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                    Index index = localTable.getPrimaryKeyIndex();
                    if (index == null) continue;
                    sum += index.getFields().length;
                }
            }
            return sum;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                Index index = localTable.getPrimaryKeyIndex();
                if (index == null) continue;
                for (Field fieldLocal : index.getFields()) {
                    Object[] row = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        if (fieldLocal == null) continue;
                        Object value = null;
                        if (this.catalog.equals(field)) {
                            value = localSchema.catalogName();
                        } else if (this.schema.equals(field)) {
                            value = localSchema.name();
                        } else if (this.table.equals(field)) {
                            value = localTable.getName();
                        } else if (this.constraintName.equals(field)) {
                            value = index.getName();
                        } else if (this.name.equals(field)) {
                            value = fieldLocal.getName();
                        } else if (this.ordinal.equals(field)) {
                            value = fieldLocal.getOrderNum();
                        }
                        row[i] = value;
                    }
                    ret.add(row);
                }
            }
        }
        return ret;
    }
}

