/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Indexes
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("index_catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("index_schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field table = new Field("table_name", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field name = new Field("index_name", 0, 255, ParadoxType.VARCHAR, this, 4);
    private final Field nonUnique = new Field("non_unique", 0, 1, ParadoxType.BOOLEAN, this, 5);
    private final Field ordinal = new Field("ordinal", 0, 4, ParadoxType.INTEGER, this, 6);
    private final Field ascOrDesc = new Field("asc_or_desc", 0, 4, ParadoxType.VARCHAR, this, 7);
    private final Field cardinality = new Field("cardinality", 0, 4, ParadoxType.INTEGER, this, 8);
    private final Field pages = new Field("pages", 0, 4, ParadoxType.INTEGER, this, 9);
    private final Field field = new Field("field", 0, 255, ParadoxType.VARCHAR, this, 10);
    private final Field type = new Field("type", 0, 255, ParadoxType.VARCHAR, this, 11);

    public Indexes(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_indexes";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.table, this.name, this.nonUnique, this.ordinal, this.ascOrDesc, this.cardinality, this.pages, this.field, this.type};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            int sum = 0;
            for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
                for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                    for (Index index : localTable.getIndexes()) {
                        sum += index.getFields().length;
                    }
                }
            }
            return sum;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                for (Index index : localTable.getIndexes()) {
                    for (Field indexField : index.getFields()) {
                        Object[] row = new Object[fields.length];
                        for (int i = 0; i < fields.length; ++i) {
                            Field localField = fields[i];
                            Object value = null;
                            if (this.catalog.equals(localField)) {
                                value = localSchema.catalogName();
                            } else if (this.schema.equals(localField)) {
                                value = localSchema.name();
                            } else if (this.table.equals(localField)) {
                                value = localTable.getName();
                            } else if (this.name.equals(localField)) {
                                value = index.getName();
                            } else if (this.nonUnique.equals(localField)) {
                                value = !index.isUnique();
                            } else if (this.ordinal.equals(localField)) {
                                value = indexField.getOrderNum();
                            } else if (this.ascOrDesc.equals(localField)) {
                                value = index.getOrder().name();
                            } else if (this.cardinality.equals(localField)) {
                                value = index.getRowCount();
                            } else if (this.pages.equals(localField)) {
                                value = index.getTotalBlocks();
                            } else if (this.field.equals(localField)) {
                                value = indexField.getName();
                            } else if (this.type.equals(localField)) {
                                value = index.type().description();
                            }
                            row[i] = value;
                        }
                        ret.add(row);
                    }
                }
            }
        }
        return ret;
    }
}

