/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.IndexType;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.SoftIndex;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Columns
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field table = new Field("table", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field name = new Field("name", 0, 255, ParadoxType.VARCHAR, this, 4);
    private final Field ordinal = new Field("ordinal", 0, 1, ParadoxType.INTEGER, this, 5);
    private final Field isNullable = new Field("is_nullable", 0, 3, ParadoxType.VARCHAR, this, 6);
    private final Field autoincrement = new Field("is_autoincrement", 0, 3, ParadoxType.VARCHAR, this, 7);
    private final Field incrementValue = new Field("autoincrement_value", 0, 0, ParadoxType.INTEGER, this, 8);
    private final Field incrementStep = new Field("autoincrement_step", 0, 0, ParadoxType.INTEGER, this, 9);
    private final Field maximumLength = new Field("maximum_length", 0, 4, ParadoxType.INTEGER, this, 10);
    private final Field octetLength = new Field("octet_length", 0, 4, ParadoxType.INTEGER, this, 11);
    private final Field precision = new Field("precision", 0, 4, ParadoxType.INTEGER, this, 12);
    private final Field radix = new Field("radix", 0, 4, ParadoxType.INTEGER, this, 13);
    private final Field scale = new Field("scale", 0, 4, ParadoxType.INTEGER, this, 14);
    private final Field type = new Field("type", 0, 255, ParadoxType.VARCHAR, this, 15);
    private final Field javaClass = new Field("java_class", 0, 255, ParadoxType.VARCHAR, this, 16);
    private final Field javaType = new Field("java_type", 0, 255, ParadoxType.VARCHAR, this, 17);
    private final Field javaTypeId = new Field("java_type_id", 0, 4, ParadoxType.INTEGER, this, 18);
    private final Field nullable = new Field("nullable", 0, 4, ParadoxType.INTEGER, this, 19);

    public Columns(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_columns";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Index[] getIndexes() {
        return new Index[]{new SoftIndex("columns.pk", true, new Field[]{this.catalog, this.schema, this.table, this.name}, IndexType.PRIMARY_KEY, this::getRowCount)};
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.table, this.name, this.ordinal, this.isNullable, this.autoincrement, this.incrementValue, this.incrementStep, this.maximumLength, this.octetLength, this.precision, this.radix, this.scale, this.type, this.javaClass, this.javaType, this.javaTypeId, this.nullable};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            int sum = 0;
            for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
                for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                    sum += localTable.getFields().length;
                }
            }
            return sum;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                for (Field fieldLocal : localTable.getFields()) {
                    Object[] row = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        if (fieldLocal == null) continue;
                        Object value = null;
                        if (this.catalog.equals(field)) {
                            value = localSchema.catalogName();
                        } else if (this.schema.equals(field)) {
                            value = localSchema.name();
                        } else if (this.table.equals(field)) {
                            value = localTable.getName();
                        } else if (this.name.equals(field)) {
                            value = fieldLocal.getName();
                        } else if (this.ordinal.equals(field)) {
                            value = fieldLocal.getOrderNum();
                        } else if (this.isNullable.equals(field)) {
                            value = fieldLocal.isAutoIncrement() ? "NO" : "YES";
                        } else if (this.autoincrement.equals(field)) {
                            value = fieldLocal.isAutoIncrement() ? "YES" : "NO";
                        } else if (this.incrementValue.equals(field) && fieldLocal.isAutoIncrement()) {
                            value = localTable.getAutoIncrementValue();
                        } else if (this.incrementStep.equals(field) && fieldLocal.isAutoIncrement()) {
                            value = 1;
                        } else if (this.maximumLength.equals(field)) {
                            value = fieldLocal.getSize();
                        } else if (this.octetLength.equals(field)) {
                            value = fieldLocal.getRealSize();
                        } else if (this.precision.equals(field)) {
                            value = fieldLocal.getPrecision();
                        } else if (this.radix.equals(field) && fieldLocal.getType() != null) {
                            value = fieldLocal.getType().getRadix();
                        } else if (this.scale.equals(field)) {
                            value = fieldLocal.getPrecision();
                        } else if (this.type.equals(field) && fieldLocal.getType() != null) {
                            value = fieldLocal.getType().name();
                        } else if (this.javaClass.equals(field) && fieldLocal.getType() != null) {
                            value = fieldLocal.getType().getJavaClass().getName();
                            if ("[B".equals(value)) {
                                value = "byte[]";
                            }
                        } else if (this.javaType.equals(field) && fieldLocal.getType() != null) {
                            value = JDBCType.valueOf(fieldLocal.getType().getSQLType()).getName();
                        } else if (this.javaTypeId.equals(field) && fieldLocal.getType() != null) {
                            value = fieldLocal.getType().getSQLType();
                        } else if (this.nullable.equals(field) && fieldLocal.getType() != null) {
                            value = fieldLocal.isAutoIncrement() ? Integer.valueOf(0) : Integer.valueOf(1);
                        }
                        row[i] = value;
                    }
                    ret.add(row);
                }
            }
        }
        return ret;
    }
}

