/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.tables;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CheckConstraints
implements Table {
    private final String catalogName;
    private final ConnectionInfo connectionInfo;
    private final Field catalog = new Field("constraint_catalog", 0, 255, ParadoxType.VARCHAR, this, 1);
    private final Field schema = new Field("constraint_schema", 0, 255, ParadoxType.VARCHAR, this, 2);
    private final Field name = new Field("constraint_name", 0, 255, ParadoxType.VARCHAR, this, 3);
    private final Field check = new Field("check_clause", 0, 10, ParadoxType.VARCHAR, this, 4);

    public CheckConstraints(ConnectionInfo connectionInfo, String catalogName) {
        this.catalogName = catalogName;
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getName() {
        return "pdx_check_constraints";
    }

    @Override
    public TableType type() {
        return TableType.SYSTEM_TABLE;
    }

    @Override
    public Field[] getFields() {
        return new Field[]{this.catalog, this.schema, this.name, this.check};
    }

    @Override
    public String getSchemaName() {
        return "information_schema";
    }

    @Override
    public int getRowCount() {
        try {
            int sum = 0;
            for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
                for (Table localTable : localSchema.list(this.connectionInfo, null)) {
                    sum += localTable.getIndexes().length;
                }
            }
            return sum;
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (Schema localSchema : this.connectionInfo.getSchemas(this.catalogName, null)) {
            for (Table table : localSchema.list(this.connectionInfo, null)) {
                for (Index index : table.getCheckConstraints()) {
                    Object[] row = new Object[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        String value = null;
                        if (this.catalog.equals(field)) {
                            value = localSchema.catalogName();
                        } else if (this.schema.equals(field)) {
                            value = localSchema.name();
                        } else if (this.name.equals(field)) {
                            value = index.getName();
                        } else if (this.check.equals(field)) {
                            value = index.definition();
                        }
                        row[i] = value;
                    }
                    ret.add(row);
                }
            }
        }
        return ret;
    }
}

