/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.schema;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.View;
import com.googlecode.paradox.metadata.tables.CheckConstraints;
import com.googlecode.paradox.metadata.tables.ColumnDomainUsage;
import com.googlecode.paradox.metadata.tables.ColumnPrivileges;
import com.googlecode.paradox.metadata.tables.Columns;
import com.googlecode.paradox.metadata.tables.Indexes;
import com.googlecode.paradox.metadata.tables.KeyColumns;
import com.googlecode.paradox.metadata.tables.Parameters;
import com.googlecode.paradox.metadata.tables.ReferentialConstraints;
import com.googlecode.paradox.metadata.tables.Routines;
import com.googlecode.paradox.metadata.tables.Schemata;
import com.googlecode.paradox.metadata.tables.TableConstraints;
import com.googlecode.paradox.metadata.tables.Tables;
import com.googlecode.paradox.metadata.tables.ViewColumnUsage;
import com.googlecode.paradox.metadata.tables.Views;
import com.googlecode.paradox.metadata.tables.Warnings;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SystemSchema
implements Schema {
    private final List<Table> tables = new ArrayList<Table>();
    private final String catalog;

    public SystemSchema(ConnectionInfo connectionInfo, String catalog) throws SQLException {
        this.catalog = catalog;
        this.tables.add(new CheckConstraints(connectionInfo, catalog));
        this.tables.add(new ColumnPrivileges());
        this.tables.add(new Columns(connectionInfo, catalog));
        this.tables.add(new ColumnDomainUsage());
        this.tables.add(new Indexes(connectionInfo, catalog));
        this.tables.add(new KeyColumns(connectionInfo, catalog));
        this.tables.add(new Parameters(catalog));
        this.tables.add(new ReferentialConstraints());
        this.tables.add(new Routines(connectionInfo, catalog));
        this.tables.add(new Schemata(connectionInfo, catalog));
        this.tables.add(new TableConstraints(connectionInfo, catalog));
        this.tables.add(new Tables(connectionInfo, catalog));
        this.tables.add(new ViewColumnUsage(connectionInfo, catalog));
        this.tables.add(new Views(connectionInfo, catalog));
        this.tables.add(new Warnings(connectionInfo, catalog));
        try {
            this.tables.add(this.load(connectionInfo, "check_constraints"));
            this.tables.add(this.load(connectionInfo, "column_domain_usage"));
            this.tables.add(this.load(connectionInfo, "column_privileges"));
            this.tables.add(this.load(connectionInfo, "columns"));
            this.tables.add(this.load(connectionInfo, "constraint_table_usage"));
            this.tables.add(this.load(connectionInfo, "key_column_usage"));
            this.tables.add(this.load(connectionInfo, "parameters"));
            this.tables.add(this.load(connectionInfo, "referential_constraints"));
            this.tables.add(this.load(connectionInfo, "routines"));
            this.tables.add(this.load(connectionInfo, "schemata"));
            this.tables.add(this.load(connectionInfo, "table_constraints"));
            this.tables.add(this.load(connectionInfo, "table_privileges"));
            this.tables.add(this.load(connectionInfo, "tables"));
            this.tables.add(this.load(connectionInfo, "view_column_usage"));
            this.tables.add(this.load(connectionInfo, "view_table_usage"));
            this.tables.add(this.load(connectionInfo, "views"));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private View load(ConnectionInfo connectionInfo, String name) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/com/googlecode/paradox/information_schema/" + name + ".sql");){
            View view = View.load(connectionInfo, "information_schema", name, is);
            return view;
        }
    }

    @Override
    public List<Table> list(ConnectionInfo connectionInfo, String tablePattern) {
        return this.tables;
    }

    @Override
    public String name() {
        return "information_schema";
    }

    @Override
    public String catalogName() {
        return this.catalog;
    }

    @Override
    public Table findTable(ConnectionInfo connectionInfo, String tableName) {
        return this.tables.stream().filter(t -> t.getName().equalsIgnoreCase(tableName)).findFirst().orElse(null);
    }
}

