/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.schema;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.data.TableData;
import com.googlecode.paradox.metadata.Schema;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.View;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DirectorySchema
implements Schema {
    private final File schemaFile;

    public DirectorySchema(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    @Override
    public List<Table> list(ConnectionInfo connectionInfo, String tablePattern) throws SQLException {
        ArrayList<Table> ret = new ArrayList<Table>();
        ret.addAll(TableData.listTables(this.schemaFile, tablePattern, connectionInfo));
        ret.addAll(View.listViews(this.schemaFile, tablePattern, connectionInfo));
        return ret;
    }

    @Override
    public String catalogName() {
        return this.schemaFile.getParentFile().getName();
    }

    @Override
    public String name() {
        return this.schemaFile.getName();
    }

    @Override
    public Table findTable(ConnectionInfo connectionInfo, String tableName) throws SQLException {
        ArrayList<Table> tables = new ArrayList<Table>();
        tables.addAll(TableData.listTables(this.schemaFile, null, connectionInfo));
        tables.addAll(View.search(connectionInfo, this.name(), this.schemaFile));
        return tables.stream().filter(table -> tableName.equalsIgnoreCase(table.getName())).findFirst().orElse(null);
    }
}

