/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.paradox;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.data.IndexData;
import com.googlecode.paradox.data.PrimaryKeyData;
import com.googlecode.paradox.data.TableData;
import com.googlecode.paradox.data.filefilters.TableFilter;
import com.googlecode.paradox.exceptions.DataError;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.metadata.paradox.ParadoxDataFile;
import com.googlecode.paradox.metadata.paradox.ParadoxPK;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.sql.SQLException;
import java.util.List;

public final class ParadoxTable
extends ParadoxDataFile
implements Table {
    private Index[] indexes = new Index[0];

    public ParadoxTable(File file, ConnectionInfo connectionInfo) {
        super(file, connectionInfo);
    }

    public FileInputStream openBlobs() throws SQLException {
        File[] fileList = this.file.getParentFile().listFiles(new TableFilter(this.connectionInfo.getLocale(), this.name, "mb"));
        if (fileList == null || fileList.length == 0) {
            throw new ParadoxDataException(DataError.BLOB_FILE_NOT_FOUND);
        }
        if (fileList.length > 1) {
            throw new ParadoxDataException(DataError.TOO_MANY_BLOB_FILES);
        }
        File blobFile = fileList[0];
        try {
            return new FileInputStream(blobFile);
        }
        catch (FileNotFoundException e) {
            throw new ParadoxDataException(DataError.ERROR_OPENING_BLOB_FILE, e);
        }
    }

    public void loadIndexes() throws SQLException {
        List<Index> loadedIndexes = IndexData.listIndexes(this.file.getParentFile(), this, this.connectionInfo);
        ParadoxPK index = PrimaryKeyData.getPrimaryKey(this.file.getParentFile(), this, this.connectionInfo);
        if (index != null) {
            loadedIndexes.add(index);
        }
        this.indexes = loadedIndexes.toArray(new Index[0]);
    }

    @Override
    public List<Object[]> load(Field[] fields) throws SQLException {
        return TableData.loadData(this, fields);
    }

    @Override
    public int getBlockSizeBytes() {
        return this.blockSize * 1024;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Index[] getIndexes() {
        return this.indexes;
    }

    @Override
    public TableType type() {
        return TableType.TABLE;
    }
}

