/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.paradox;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.paradox.ParadoxDataFile;
import com.googlecode.paradox.planner.sorting.OrderType;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class ParadoxIndex
extends ParadoxDataFile
implements Index {
    private Table table;

    public ParadoxIndex(File file, ConnectionInfo connectionInfo) {
        super(file, connectionInfo);
    }

    @Override
    public OrderType getOrder() {
        byte referential = this.getReferentialIntegrity();
        if (referential == 16 || referential == 17 || referential == 48) {
            return OrderType.DESC;
        }
        return OrderType.ASC;
    }

    @Override
    public boolean isUnique() {
        byte referential = this.getReferentialIntegrity();
        return referential == 32 || referential == 33 || referential == 48;
    }

    @Override
    public Field[] getFields() {
        HashSet<Field> tableFields = new HashSet<Field>(Arrays.asList(this.table.getFields()));
        return (Field[])Arrays.stream(this.fields).filter(field -> ParadoxIndex.filterFields(field, tableFields)).toArray(Field[]::new);
    }

    private static boolean filterFields(Field field, Set<Field> tableFields) {
        Iterator<Field> i = tableFields.iterator();
        while (i.hasNext()) {
            Field f = i.next();
            if (!f.getName().equals(field.getName())) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public void setTable(Table table) {
        this.table = table;
        Arrays.stream(this.fields).forEach(field -> field.setTable(table));
    }
}

