/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.paradox;

import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.paradox.ParadoxTable;
import com.googlecode.paradox.results.ParadoxType;
import java.util.Objects;

public final class ParadoxField
extends Field {
    private static final int NUMBER_PRECISION = 3;
    private static final int CURRENCY_PRECISION = 2;

    public ParadoxField(ParadoxType type) {
        this(type, 1);
    }

    public ParadoxField(ParadoxType type, int orderNum) {
        this.type = type;
        this.orderNum = orderNum;
    }

    @Override
    public void setSize(int size) {
        this.realSize = size;
        int sqlType = this.getSqlType();
        if (this.type == ParadoxType.CURRENCY) {
            this.precision = 2;
            this.size = size;
        } else if (this.type == ParadoxType.BCD) {
            this.realSize = 17;
            this.precision = size;
            this.size = 32;
        } else if (sqlType == 2) {
            this.precision = 3;
            this.size = size;
        } else {
            this.size = size;
        }
    }

    @Override
    public String toString() {
        if (this.table == null) {
            return this.name;
        }
        return this.table.getName() + "." + this.name;
    }

    @Override
    public ParadoxTable getTable() {
        return (ParadoxTable)this.table;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParadoxField that = (ParadoxField)o;
        return this.orderNum == that.orderNum && this.size == that.size && this.type == that.type && Objects.equals(this.alias, that.alias) && Objects.equals(this.name, that.name) && Objects.equals(this.table, that.table);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alias, this.name, this.orderNum, this.size, this.table, this.type);
    }
}

