/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata.paradox;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.utils.Utils;
import java.io.File;
import java.nio.charset.Charset;

public class ParadoxDataFile {
    protected final File file;
    protected Field[] fields;
    protected byte blockSize;
    protected String name;
    private int autoIncrementValue;
    protected Charset charset;
    private int fieldCount;
    private short[] fieldsOrder;
    private int firstBlock;
    private int firstFreeBlock;
    private int headerSize;
    private int lastBlock;
    private int primaryFieldCount;
    private int recordSize;
    private byte referentialIntegrity;
    private int rowCount;
    private int totalBlocks;
    private byte type = (byte)-1;
    private int usedBlocks;
    private byte versionId;
    private boolean writeProtected;
    private long encryptedData;
    private String sortOrderID;
    protected final ConnectionInfo connectionInfo;

    public ParadoxDataFile(File file, ConnectionInfo connectionInfo) {
        this.file = file;
        this.name = Utils.removeSuffix(file.getName(), "DB");
        this.connectionInfo = connectionInfo;
        if (connectionInfo != null && connectionInfo.getCharset() != null) {
            this.charset = connectionInfo.getCharset();
        }
    }

    public Field findField(String name) {
        for (Field field : this.fields) {
            if (!field.getName().equalsIgnoreCase(name)) continue;
            return field;
        }
        return null;
    }

    public String getSortOrderID() {
        return this.sortOrderID;
    }

    public void setSortOrderID(String sortOrderID) {
        this.sortOrderID = sortOrderID;
    }

    public String getSchemaName() {
        return this.file.getParentFile().getName();
    }

    public int getAutoIncrementValue() {
        return this.autoIncrementValue;
    }

    public void setAutoIncrementValue(int autoIncrementValue) {
        this.autoIncrementValue = autoIncrementValue;
    }

    public void setBlockSize(byte blockSize) {
        this.blockSize = blockSize;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void setFieldCount(int fieldCount) {
        this.fieldCount = fieldCount;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
    }

    public short[] getFieldsOrder() {
        return this.fieldsOrder;
    }

    public void setFieldsOrder(short[] fieldsOrder) {
        this.fieldsOrder = fieldsOrder;
    }

    public File getFile() {
        return this.file;
    }

    public int getFirstBlock() {
        return this.firstBlock;
    }

    public void setFirstBlock(int firstBlock) {
        this.firstBlock = firstBlock;
    }

    public int getFirstFreeBlock() {
        return this.firstFreeBlock;
    }

    public void setFirstFreeBlock(int firstFreeBlock) {
        this.firstFreeBlock = firstFreeBlock;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public int getLastBlock() {
        return this.lastBlock;
    }

    public void setLastBlock(int lastBlock) {
        this.lastBlock = lastBlock;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPrimaryFieldCount() {
        return this.primaryFieldCount;
    }

    public void setPrimaryFieldCount(int primaryFieldCount) {
        this.primaryFieldCount = primaryFieldCount;
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    public void setRecordSize(int recordSize) {
        this.recordSize = recordSize;
    }

    public byte getReferentialIntegrity() {
        return this.referentialIntegrity;
    }

    public void setReferentialIntegrity(byte referentialIntegrity) {
        this.referentialIntegrity = referentialIntegrity;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public void setTotalBlocks(int totalBlocks) {
        this.totalBlocks = totalBlocks;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public int getUsedBlocks() {
        return this.usedBlocks;
    }

    public void setUsedBlocks(int usedBlocks) {
        this.usedBlocks = usedBlocks;
    }

    public byte getVersionId() {
        return this.versionId;
    }

    public void setVersionId(byte versionId) {
        this.versionId = versionId;
    }

    public boolean isWriteProtected() {
        return this.writeProtected;
    }

    public void setWriteProtected(boolean writeProtected) {
        this.writeProtected = writeProtected;
    }

    public boolean isEncrypted() {
        return this.encryptedData != 0L;
    }

    public long getEncryptedData() {
        return this.encryptedData;
    }

    public void setEncryptedData(long encryptedData) {
        this.encryptedData = encryptedData;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }
}

