/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.data.filefilters.SQLFilter;
import com.googlecode.paradox.exceptions.ParadoxNotSupportedException;
import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.metadata.TableType;
import com.googlecode.paradox.parser.SQLParser;
import com.googlecode.paradox.planner.Planner;
import com.googlecode.paradox.planner.context.SelectContext;
import com.googlecode.paradox.planner.nodes.PlanTableNode;
import com.googlecode.paradox.planner.plan.Plan;
import com.googlecode.paradox.planner.plan.SelectPlan;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.utils.Expressions;
import com.googlecode.paradox.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class View
implements Table {
    private final ConnectionInfo connectionInfo;
    private final String definition;
    private final String name;
    private final String schemaName;
    private SelectPlan selectPlan;
    private Field[] fields;

    public View(ConnectionInfo connectionInfo, String schemaName, String name, String definition) {
        this.connectionInfo = connectionInfo;
        this.definition = definition;
        this.name = name;
        this.schemaName = schemaName;
    }

    private SelectPlan getSelectPlan() throws SQLException {
        if (this.selectPlan == null) {
            SQLParser parser = new SQLParser(this.definition);
            Plan<?, ?> plan = Planner.create(this.connectionInfo, parser.parse());
            if (!(plan instanceof SelectPlan) || plan.getParameterCount() > 0) {
                throw new ParadoxNotSupportedException(ParadoxNotSupportedException.Error.OPERATION_NOT_SUPPORTED);
            }
            this.selectPlan = (SelectPlan)plan;
        }
        return this.selectPlan;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TableType type() {
        return TableType.VIEW;
    }

    @Override
    public Field[] getFields() {
        if (this.fields == null) {
            try {
                this.fields = (Field[])this.getSelectPlan().getColumns().stream().map(column -> {
                    Field field = new Field((Column)column);
                    field.setTable(this);
                    return field;
                }).toArray(Field[]::new);
            }
            catch (SQLException e) {
                this.connectionInfo.addWarning(e);
                this.fields = new Field[0];
            }
        }
        return this.fields;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public int getRowCount() {
        try {
            return this.load(new Field[0]).size();
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public List<Object[]> load(Field[] fieldsToLoad) throws SQLException {
        Field[] fieldsLoaded = this.getFields();
        int[] mapColumns = new int[fieldsToLoad.length];
        Arrays.fill(mapColumns, -1);
        block0: for (int i = 0; i < fieldsToLoad.length; ++i) {
            Field field = fieldsToLoad[i];
            for (int loop = 0; loop < fieldsLoaded.length; ++loop) {
                if (!fieldsLoaded[loop].equals(field)) continue;
                mapColumns[i] = loop;
                continue block0;
            }
        }
        SelectContext context = this.getSelectPlan().createContext(this.connectionInfo, null, null);
        return this.getSelectPlan().execute(context).stream().map(row -> {
            Object[] newRow = new Object[mapColumns.length];
            for (int i = 0; i < mapColumns.length; ++i) {
                newRow[i] = row[mapColumns[i]];
            }
            return newRow;
        }).collect(Collectors.toList());
    }

    public String definition() {
        return String.format("create view \"%s\".\"%s\" as %s%n", this.schemaName, this.name, this.definition);
    }

    public Field[] usages() throws SQLException {
        return (Field[])this.getSelectPlan().getTables().stream().map(PlanTableNode::getColumns).flatMap(Collection::stream).map(Column::getField).toArray(Field[]::new);
    }

    public static List<View> listViews(File currentSchema, String viewNamePattern, ConnectionInfo connectionInfo) {
        return View.search(connectionInfo, currentSchema.getName(), currentSchema).stream().filter(view -> viewNamePattern == null || Expressions.accept(connectionInfo.getLocale(), view.getName(), viewNamePattern, false, '\\')).collect(Collectors.toList());
    }

    public static List<View> search(ConnectionInfo connectionInfo, String schemaName, File directory) {
        File[] files;
        ArrayList<View> views = new ArrayList<View>();
        if (directory.isDirectory() && (files = directory.listFiles(new SQLFilter(connectionInfo.getLocale()))) != null) {
            Arrays.stream(files).filter(Objects::nonNull).forEach(file -> {
                try {
                    views.add(View.load(connectionInfo, schemaName, file));
                }
                catch (IOException e) {
                    connectionInfo.addWarning(e);
                }
            });
        }
        return views;
    }

    public static View load(ConnectionInfo connectionInfo, String schemaName, String name, InputStream inputStream) throws IOException {
        char[] buffer = new char[2048];
        StringBuilder out = new StringBuilder();
        try (InputStreamReader in = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            int rsz;
            while ((rsz = in.read(buffer, 0, buffer.length)) > 0) {
                out.append(buffer, 0, rsz);
            }
        }
        return new View(connectionInfo, schemaName, name, out.toString());
    }

    public static View load(ConnectionInfo connectionInfo, String schemaName, File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            View view = View.load(connectionInfo, schemaName, Utils.removeSuffix(file.getName()), fis);
            return view;
        }
    }
}

