/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata;

import com.googlecode.paradox.metadata.Field;
import com.googlecode.paradox.metadata.Index;
import com.googlecode.paradox.metadata.IndexType;
import com.googlecode.paradox.metadata.TableType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public interface Table {
    public String getName();

    public int getRowCount();

    public TableType type();

    default public boolean isWriteProtected() {
        return true;
    }

    public Field[] getFields();

    public String getSchemaName();

    default public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    public List<Object[]> load(Field[] var1) throws SQLException;

    default public Index getPrimaryKeyIndex() {
        return Arrays.stream(this.getIndexes()).filter(index -> index.type() == IndexType.PRIMARY_KEY).findFirst().orElse(null);
    }

    default public Index[] getIndexes() {
        return new Index[0];
    }

    default public Index[] getCheckConstraints() {
        return (Index[])Arrays.stream(this.getIndexes()).filter(index -> index.type() == IndexType.CHECK).toArray(Index[]::new);
    }

    default public Index[] getConstraints() {
        return (Index[])Arrays.stream(this.getIndexes()).filter(index -> index.type() != IndexType.INDEX).toArray(Index[]::new);
    }

    default public boolean isEncrypted() {
        return false;
    }

    default public int getAutoIncrementValue() {
        return 0;
    }

    default public int getBlockSizeBytes() {
        return 0;
    }

    default public int getTotalBlocks() {
        return 0;
    }

    default public int getUsedBlocks() {
        return 0;
    }

    default public int getRecordSize() {
        return Arrays.stream(this.getFields()).mapToInt(Field::getRealSize).sum();
    }

    default public String description(Boolean value) {
        if (Boolean.TRUE.equals(value)) {
            return "YES";
        }
        return "NO";
    }
}

