/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxException;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.utils.Utils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class ParadoxResultSetMetaData
implements ResultSetMetaData {
    private final List<Column> columns;
    private final ConnectionInfo connectionInfo;

    public ParadoxResultSetMetaData(ConnectionInfo connectionInfo, List<Column> columns) {
        this.columns = Collections.unmodifiableList(columns);
        this.connectionInfo = connectionInfo;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        this.getColumn(column);
        return this.connectionInfo.getCatalog();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return ParadoxType.valueOf(this.getColumnType(column)).getJavaClass().getName();
    }

    @Override
    public int getColumnCount() {
        return (int)this.columns.stream().filter(c -> !c.isHidden()).count();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.getField().getSize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.getName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.getType().getSQLType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.getType().name();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.getScale();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        this.getColumn(column);
        return this.connectionInfo.getCurrentSchema().name();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.getTableName();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        this.getColumn(column);
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.isCurrency();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.isWritable(column);
    }

    @Override
    public int isNullable(int column) throws SQLException {
        Column dto = this.getColumn(column);
        if (dto.isNullable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.isReadOnly();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.isSearchable();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.isSigned();
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) {
        return Utils.isWrapperFor(this, iFace);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        Column dto = this.getColumn(column);
        return dto.isWritable();
    }

    @Override
    public <T> T unwrap(Class<T> face) throws SQLException {
        return Utils.unwrap(this, face);
    }

    private Column getColumn(int column) throws SQLException {
        return this.columns.stream().filter(c -> !c.isHidden()).filter(c -> c.getIndex() == column).findFirst().orElseThrow(() -> new ParadoxException(ParadoxException.Error.INVALID_COLUMN, column));
    }
}

