/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.ParadoxConnection;
import com.googlecode.paradox.ParadoxResultSet;
import com.googlecode.paradox.exceptions.ParadoxDataException;
import com.googlecode.paradox.function.AbstractFunction;
import com.googlecode.paradox.function.FunctionFactory;
import com.googlecode.paradox.function.FunctionType;
import com.googlecode.paradox.planner.context.SelectContext;
import com.googlecode.paradox.planner.plan.SelectPlan;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.utils.Expressions;
import com.googlecode.paradox.utils.Utils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ParadoxDatabaseMetaData
implements DatabaseMetaData {
    private static final int JDBC_MAJOR_VERSION = 4;
    private static final int JDBC_MINOR_VERSION = 2;
    private static final int PARADOX_MAJOR_VERSION = 7;
    private static final int PARADOX_MAX_COLUMN_NAME = 8;
    private static final int PARADOX_MINOR_VERSION = 0;
    private static final int STRING_MAX_SIZE = 255;
    private final ConnectionInfo connectionInfo;
    private final ParadoxConnection connection;

    public ParadoxDatabaseMetaData(ParadoxConnection connection) {
        this.connection = connection;
        this.connectionInfo = connection.getConnectionInfo();
    }

    @Override
    public boolean allProceduresAreCallable() {
        return true;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return true;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return true;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public String getCatalogSeparator() {
        return ".";
    }

    @Override
    public String getCatalogTerm() {
        return "CATALOG";
    }

    @Override
    public ResultSet getClientInfoProperties() {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public int getDatabaseMajorVersion() {
        return 7;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return 0;
    }

    @Override
    public String getDatabaseProductName() {
        return "Paradox Driver";
    }

    @Override
    public String getDatabaseProductVersion() {
        return "Paradox Driver 1.6";
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 6;
    }

    @Override
    public String getDriverName() {
        return "Paradox Driver";
    }

    @Override
    public String getDriverVersion() {
        return "1.6";
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column("FUNCTION_CAT", ParadoxType.VARCHAR));
        columns.add(new Column("FUNCTION_SCHEM", ParadoxType.VARCHAR));
        columns.add(new Column("FUNCTION_NAME", ParadoxType.VARCHAR));
        columns.add(new Column("COLUMN_NAME", ParadoxType.VARCHAR));
        columns.add(new Column("COLUMN_TYPE", ParadoxType.INTEGER));
        columns.add(new Column("DATA_TYPE", ParadoxType.INTEGER));
        columns.add(new Column("TYPE_NAME", ParadoxType.VARCHAR));
        columns.add(new Column("PRECISION", ParadoxType.INTEGER));
        columns.add(new Column("LENGTH", ParadoxType.INTEGER));
        columns.add(new Column("SCALE", ParadoxType.INTEGER));
        columns.add(new Column("RADIX", ParadoxType.INTEGER));
        columns.add(new Column("NULLABLE", ParadoxType.INTEGER));
        columns.add(new Column("REMARKS", ParadoxType.VARCHAR));
        columns.add(new Column("CHAR_OCTET_LENGTH", ParadoxType.INTEGER));
        columns.add(new Column("ORDINAL_POSITION", ParadoxType.INTEGER));
        columns.add(new Column("IS_NULLABLE", ParadoxType.VARCHAR));
        columns.add(new Column("SPECIFIC_NAME", ParadoxType.VARCHAR));
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (Map.Entry<String, Supplier<? extends AbstractFunction>> function : FunctionFactory.getFunctions().entrySet()) {
            if (!catalog.equalsIgnoreCase(this.connectionInfo.getCatalog()) && !Expressions.accept(this.connectionInfo.getLocale(), this.connectionInfo.getCurrentSchema().name(), schemaPattern, false, '\\') && !Expressions.accept(this.connectionInfo.getLocale(), function.getKey(), functionNamePattern, false, '\\')) continue;
            AbstractFunction instance = function.getValue().get();
            for (Column column : instance.getColumns()) {
                if (!Expressions.accept(this.connectionInfo.getLocale(), column.getName(), columnNamePattern, false, '\\')) continue;
                String nullableText = "NO";
                int nullable = 0;
                if (column.isNullable()) {
                    nullableText = "YES";
                    nullable = 1;
                }
                Object[] row = new Object[]{this.connectionInfo.getCatalog(), null, function.getKey(), column.getName(), column.getColumnType(), column.getType().getSQLType(), column.getType().name(), column.getSize(), column.getSize(), column.getPrecision(), column.getRadix(), nullable, column.getRemarks(), column.getOctets(), column.getIndex(), nullableText, null};
                values.add(row);
            }
        }
        return new ParadoxResultSet(this.connectionInfo, null, values, columns);
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String sql = "select \"catalog\" as FUNCTION_CAT,\n       \"schema\" as FUNCTION_SCHEM,\n       name as FUNCTION_NAME,\n       remarks as REMARKS,\n       cast(1 as numeric) as FUNCTION_TYPE,\n       name as SPECIFIC_NAME\nfrom information_schema.pdx_routines\nwhere (? is null or \"catalog\" = ?)\n  and (? is null or \"schema\" ilike ?)\n  and (? is null or \"name\" ilike ?)\n  and type = 'FUNCTION'\norder by \"catalog\", \"schema\", name";
        SelectPlan selectPlan = (SelectPlan)this.connection.createPlan("select \"catalog\" as FUNCTION_CAT,\n       \"schema\" as FUNCTION_SCHEM,\n       name as FUNCTION_NAME,\n       remarks as REMARKS,\n       cast(1 as numeric) as FUNCTION_TYPE,\n       name as SPECIFIC_NAME\nfrom information_schema.pdx_routines\nwhere (? is null or \"catalog\" = ?)\n  and (? is null or \"schema\" ilike ?)\n  and (? is null or \"name\" ilike ?)\n  and type = 'FUNCTION'\norder by \"catalog\", \"schema\", name");
        SelectContext context = selectPlan.createContext(this.connectionInfo, new Object[]{catalog, catalog, schemaPattern, schemaPattern, functionNamePattern, functionNamePattern}, new ParadoxType[]{ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR});
        List<Object[]> values = selectPlan.execute(context);
        return new ParadoxResultSet(this.connectionInfo, null, values, selectPlan.getColumns());
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getCatalogs() throws ParadoxDataException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String sql = "select \"catalog\"             as TABLE_CAT,\n       \"schema\"              as TABLE_SCHEM,\n       \"table\"               as TABLE_NAME,\n       name                  as COLUMN_NAME,\n       java_type_id          as DATA_TYPE,\n       type                  as TYPE_NAME,\n       maximum_length        as COLUMN_SIZE,\n       cast(null as numeric) as BUFFER_LENGTH,\n       scale                 as DECIMAL_DIGITS,\n       radix                 as DECIMAL_DIGITS,\n       nullable              as NULLABLE,\n       cast(null as varchar) as REMARKS,\n       cast(null as varchar) as COLUMN_DEF,\n       java_type_id          as SQL_DATA_TYPE,\n       0                     as SQL_DATETIME_SUB,\n       \"octet_length\"        as CHAR_OCTET_LENGTH,\n       ordinal               as ORDINAL_POSITION,\n       is_nullable           as IS_NULLABLE,\n       cast(null as varchar) as SCOPE_CATALOG,\n       cast(null as varchar) as SCOPE_SCHEMA,\n       java_type_id          as SOURCE_DATA_TYPE,\n       is_autoincrement      as IS_AUTOINCREMENT,\n       'NO'                  as IS_GENERATEDCOLUMN\nfrom information_schema.pdx_columns\nwhere (? is null or \"catalog\" = ?)\n  and (? is null or \"schema\" ilike ?)\n  and (? is null or \"table\" ilike ?)\n  and (? is null or name ilike ?)\norder by \"catalog\", \"schema\", name";
        SelectPlan selectPlan = (SelectPlan)this.connection.createPlan("select \"catalog\"             as TABLE_CAT,\n       \"schema\"              as TABLE_SCHEM,\n       \"table\"               as TABLE_NAME,\n       name                  as COLUMN_NAME,\n       java_type_id          as DATA_TYPE,\n       type                  as TYPE_NAME,\n       maximum_length        as COLUMN_SIZE,\n       cast(null as numeric) as BUFFER_LENGTH,\n       scale                 as DECIMAL_DIGITS,\n       radix                 as DECIMAL_DIGITS,\n       nullable              as NULLABLE,\n       cast(null as varchar) as REMARKS,\n       cast(null as varchar) as COLUMN_DEF,\n       java_type_id          as SQL_DATA_TYPE,\n       0                     as SQL_DATETIME_SUB,\n       \"octet_length\"        as CHAR_OCTET_LENGTH,\n       ordinal               as ORDINAL_POSITION,\n       is_nullable           as IS_NULLABLE,\n       cast(null as varchar) as SCOPE_CATALOG,\n       cast(null as varchar) as SCOPE_SCHEMA,\n       java_type_id          as SOURCE_DATA_TYPE,\n       is_autoincrement      as IS_AUTOINCREMENT,\n       'NO'                  as IS_GENERATEDCOLUMN\nfrom information_schema.pdx_columns\nwhere (? is null or \"catalog\" = ?)\n  and (? is null or \"schema\" ilike ?)\n  and (? is null or \"table\" ilike ?)\n  and (? is null or name ilike ?)\norder by \"catalog\", \"schema\", name");
        SelectContext context = selectPlan.createContext(this.connectionInfo, new Object[]{catalog, catalog, schemaPattern, schemaPattern, tableNamePattern, tableNamePattern, columnNamePattern, columnNamePattern}, new ParadoxType[]{ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR});
        List<Object[]> values = selectPlan.execute(context);
        return new ParadoxResultSet(this.connectionInfo, null, values, selectPlan.getColumns());
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schemaName, String tableNamePattern, boolean unique, boolean approximate) throws SQLException {
        String sql = "select index_catalog as      TABLE_CAT,\n       index_schema  as      TABLE_SCHEM,\n       table_name    as      TABLE_NAME,\n       non_unique    as      NON_UNIQUE,\n       index_catalog as      INDEX_QUALIFIER,\n       index_name    as INDEX_NAME,\n       cast(2 as NUMERIC) as TYPE,\n       ordinal as ORDINAL_POSITION,\n       field as COLUMN_NAME,\n       substring(asc_or_desc, 1, 1) as ASC_OR_DESC,\n       cardinality as CARDINALITY,\n       pages as PAGES,\n       cast(null as VARCHAR) FILTER_CONDITION\nfrom information_schema.pdx_indexes\nwhere (? is null or upper(\"index_catalog\") ilike upper(?))\n  and (? is null or upper(\"index_schema\") ilike upper(?))\n  and (? is null or \"table_name\" ilike ?)\n  and (? = false or non_unique = false)\norder by non_unique, index_name, ordinal";
        SelectPlan selectPlan = (SelectPlan)this.connection.createPlan("select index_catalog as      TABLE_CAT,\n       index_schema  as      TABLE_SCHEM,\n       table_name    as      TABLE_NAME,\n       non_unique    as      NON_UNIQUE,\n       index_catalog as      INDEX_QUALIFIER,\n       index_name    as INDEX_NAME,\n       cast(2 as NUMERIC) as TYPE,\n       ordinal as ORDINAL_POSITION,\n       field as COLUMN_NAME,\n       substring(asc_or_desc, 1, 1) as ASC_OR_DESC,\n       cardinality as CARDINALITY,\n       pages as PAGES,\n       cast(null as VARCHAR) FILTER_CONDITION\nfrom information_schema.pdx_indexes\nwhere (? is null or upper(\"index_catalog\") ilike upper(?))\n  and (? is null or upper(\"index_schema\") ilike upper(?))\n  and (? is null or \"table_name\" ilike ?)\n  and (? = false or non_unique = false)\norder by non_unique, index_name, ordinal");
        SelectContext context = selectPlan.createContext(this.connectionInfo, new Object[]{catalog, catalog, schemaName, schemaName, tableNamePattern, tableNamePattern, unique, unique}, new ParadoxType[]{ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.BOOLEAN, ParadoxType.BOOLEAN});
        List<Object[]> values = selectPlan.execute(context);
        return new ParadoxResultSet(this.connectionInfo, null, values, selectPlan.getColumns());
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 2;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 8;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 255;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 255;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 8;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 255;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 255;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 255;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 255;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 255;
    }

    @Override
    public int getMaxConnections() {
        return 1;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 255;
    }

    @Override
    public int getMaxIndexLength() {
        return 255;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 255;
    }

    @Override
    public int getMaxRowSize() {
        return 255;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 255;
    }

    @Override
    public int getMaxStatementLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxStatements() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxTableNameLength() {
        return 255;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 255;
    }

    @Override
    public int getMaxUserNameLength() {
        return 255;
    }

    @Override
    public String getNumericFunctions() {
        return FunctionFactory.getByType(FunctionType.NUMERIC);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schemaName, String tableNamePattern) throws SQLException {
        String sql = "select \"catalog\"       as TABLE_CAT,\n       \"schema\"        as TABLE_SCHEM,\n       \"table\"         as TABLE_NAME,\n       name            as COLUMN_NAME,\n       ordinal         as KEY_SEQ,\n       constraint_name as PK_NAME\nfrom information_schema.pdx_key_columns\nwhere (? is null or \"catalog\" = ?)\n  and (? is null or \"schema\" = ?)\n  and (? is null or \"table\" ilike ?)\norder by name";
        SelectPlan selectPlan = (SelectPlan)this.connection.createPlan("select \"catalog\"       as TABLE_CAT,\n       \"schema\"        as TABLE_SCHEM,\n       \"table\"         as TABLE_NAME,\n       name            as COLUMN_NAME,\n       ordinal         as KEY_SEQ,\n       constraint_name as PK_NAME\nfrom information_schema.pdx_key_columns\nwhere (? is null or \"catalog\" = ?)\n  and (? is null or \"schema\" = ?)\n  and (? is null or \"table\" ilike ?)\norder by name");
        SelectContext context = selectPlan.createContext(this.connectionInfo, new Object[]{catalog, catalog, schemaName, schemaName, tableNamePattern, tableNamePattern}, new ParadoxType[]{ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR});
        List<Object[]> values = selectPlan.execute(context);
        return new ParadoxResultSet(this.connectionInfo, null, values, selectPlan.getColumns());
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public String getProcedureTerm() {
        return "PROCEDURE";
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public int getResultSetHoldability() {
        return this.connection.getHoldability();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column("TABLE_SCHEM", ParadoxType.VARCHAR));
        columns.add(new Column("TABLE_CATALOG", ParadoxType.VARCHAR));
        ArrayList values = new ArrayList();
        for (String catalogName : this.connectionInfo.listCatalogs()) {
            if (catalog != null && !Expressions.accept(this.connectionInfo.getLocale(), catalogName, catalog, false, '\\')) continue;
            values.addAll(this.connectionInfo.getSchemas(catalogName, schemaPattern).stream().map(schema -> new String[]{schema.name(), catalogName}).collect(Collectors.toList()));
        }
        return new ParadoxResultSet(this.connectionInfo, null, values, columns);
    }

    @Override
    public String getSchemaTerm() {
        return "SCHEMA";
    }

    @Override
    public String getSearchStringEscape() {
        return Character.toString('\\');
    }

    @Override
    public String getSQLKeywords() {
        return "ILIKE";
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public String getStringFunctions() {
        return FunctionFactory.getByType(FunctionType.STRING);
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public String getSystemFunctions() {
        return FunctionFactory.getByType(FunctionType.SYSTEM);
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column("TABLE_SCHEM", ParadoxType.VARCHAR));
        columns.add(new Column("TABLE_CATALOG", ParadoxType.VARCHAR));
        ArrayList values = new ArrayList();
        for (String catalog : this.connectionInfo.listCatalogs()) {
            values.addAll(this.connectionInfo.getSchemas(catalog, null).stream().map(schema -> new String[]{schema.name(), catalog}).collect(Collectors.toList()));
        }
        return new ParadoxResultSet(this.connectionInfo, null, values, columns);
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String sql = "select \"catalog\"             as TABLE_CAT,\n       \"schema\"            as TABLE_SCHEM,\n       name                  as TABLE_NAME,\n       type_name             as TABLE_TYPE,\n       cast(null as VARCHAR) as REMARKS,\n       cast(null as VARCHAR) as TYPE_CAT,\n       cast(null as VARCHAR) as TYPE_SCHEM,\n       cast(null as VARCHAR) as SELF_REFERENCING_COL_NAME,\n       cast(null as VARCHAR) as REF_GENERATION\nfrom information_schema.pdx_tables\nwhere (? is null or \"catalog\" = ?)\n    and (? is null or \"schema\" ilike ?)\n";
        if (types != null) {
            sql = sql + " and upper(type_name) in (" + Arrays.stream(types).map(type -> "'" + type + "'").map(String::toUpperCase).collect(Collectors.joining(",")) + ") ";
        }
        sql = sql + " order by \"catalog\", \"schema\", name ";
        SelectPlan selectPlan = (SelectPlan)this.connection.createPlan(sql);
        SelectContext context = selectPlan.createContext(this.connectionInfo, new Object[]{catalog, catalog, schemaPattern, schemaPattern}, new ParadoxType[]{ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR, ParadoxType.VARCHAR});
        List<Object[]> values = selectPlan.execute(context);
        return new ParadoxResultSet(this.connectionInfo, null, values, selectPlan.getColumns());
    }

    @Override
    public String getTimeDateFunctions() {
        return FunctionFactory.getByType(FunctionType.TIME_DATE);
    }

    @Override
    public ResultSet getTypeInfo() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column("TYPE_NAME", ParadoxType.VARCHAR));
        columns.add(new Column("DATA_TYPE", ParadoxType.INTEGER));
        columns.add(new Column("PRECISION", ParadoxType.INTEGER));
        columns.add(new Column("LITERAL_PREFIX", ParadoxType.VARCHAR));
        columns.add(new Column("LITERAL_SUFFIX", ParadoxType.VARCHAR));
        columns.add(new Column("CREATE_PARAMS", ParadoxType.VARCHAR));
        columns.add(new Column("NULLABLE", ParadoxType.INTEGER));
        columns.add(new Column("CASE_SENSITIVE", ParadoxType.BOOLEAN));
        columns.add(new Column("SEARCHABLE", ParadoxType.INTEGER));
        columns.add(new Column("UNSIGNED_ATTRIBUTE", ParadoxType.BOOLEAN));
        columns.add(new Column("FIXED_PREC_SCALE", ParadoxType.BOOLEAN));
        columns.add(new Column("AUTO_INCREMENT", ParadoxType.BOOLEAN));
        columns.add(new Column("LOCAL_TYPE_NAME", ParadoxType.VARCHAR));
        columns.add(new Column("MINIMUM_SCALE", ParadoxType.INTEGER));
        columns.add(new Column("MAXIMUM_SCALE", ParadoxType.INTEGER));
        columns.add(new Column("SQL_DATA_TYPE", ParadoxType.INTEGER));
        columns.add(new Column("SQL_DATETIME_SUB", ParadoxType.INTEGER));
        columns.add(new Column("NUM_PREC_RADIX", ParadoxType.INTEGER));
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (ParadoxType type : ParadoxType.values()) {
            int searchable = 0;
            if (type.isSearchable()) {
                searchable = 3;
            }
            Object[] row = new Object[]{type.getName(), type.getSQLType(), type.getPrecision(), null, null, null, 2, false, searchable, type.isNumeric(), type == ParadoxType.CURRENCY, type == ParadoxType.AUTO_INCREMENT, null, 0, type.getPrecision(), type.getSQLType(), 0, type.getRadix()};
            values.add(row);
        }
        return new ParadoxResultSet(this.connectionInfo, null, values, columns);
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public String getURL() {
        return this.connectionInfo.getUrl();
    }

    @Override
    public String getUserName() {
        return this.connectionInfo.getUser();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) {
        return new ParadoxResultSet(this.connectionInfo, null, Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> iFace) {
        return Utils.isWrapperFor(this, iFace);
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return true;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return type == 1003 || type == 1004 || type == 1005;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return 0 != level;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iFace) throws SQLException {
        return Utils.unwrap(this, iFace);
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return true;
    }

    @Override
    public boolean usesLocalFiles() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getTableTypes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

