/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.metadata;

import com.googlecode.paradox.metadata.Table;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.util.Objects;

public class Field {
    protected String name;
    protected int precision;
    protected int size;
    protected ParadoxType type;
    protected Table table;
    protected String alias;
    protected int orderNum;
    protected int realSize;

    public Field() {
    }

    public Field(String name, int precision, int size, ParadoxType type, Table table, int orderNum) {
        this.name = name;
        this.precision = precision;
        this.size = size;
        this.realSize = size;
        this.type = type;
        this.table = table;
        this.orderNum = orderNum;
    }

    public Field(Column column) {
        this.name = column.getName();
        this.alias = column.getName();
        this.precision = column.getPrecision();
        this.size = column.getSize();
        this.realSize = column.getSize();
        this.type = column.getType();
        this.orderNum = column.getIndex();
        if (column.getField() != null) {
            this.precision = column.getField().precision;
            this.size = column.getField().size;
            this.type = column.getField().type;
            this.realSize = column.getField().realSize;
        }
    }

    public String getAlias() {
        if (this.alias == null) {
            return this.name;
        }
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public ParadoxType getType() {
        return this.type;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isAutoIncrement() {
        return this.type == ParadoxType.AUTO_INCREMENT;
    }

    public int getSqlType() {
        return this.type.getSQLType();
    }

    public int getOrderNum() {
        return this.orderNum;
    }

    public void setType(ParadoxType type) {
        this.type = type;
    }

    public int getRealSize() {
        return this.realSize;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        return Objects.equals(this.name, field.name) && Objects.equals(this.table, field.table) && Objects.equals(this.alias, field.alias);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.table, this.alias);
    }
}

