/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.system;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.system.AbstractSystemFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;

public class VersionFunction
extends AbstractSystemFunction {
    public static final String NAME = "VERSION";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The driver version.", 0, false, 5)};

    @Override
    public String getRemarks() {
        return "Gets the driver version.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        String system = String.format("%s %s (%s), %s %s (%s)", System.getProperty("java.vm.name"), System.getProperty("java.runtime.version"), System.getProperty("java.vendor.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        return String.format("%s %s on %s", "Paradox Driver", "1.6", system);
    }
}

