/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;

public class VarcharFunction
extends AbstractStringFunction {
    public static final String NAME = "VARCHAR";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "A varchar type value.", 0, false, 5), new Column("value", ParadoxType.VARCHAR, "A value to convert.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Converts the value to VARCHAR type.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        return ValuesConverter.getString(values[0], connectionInfo);
    }
}

