/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.parser.nodes.SQLNode;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.utils.Utils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TrimFunction
extends AbstractStringFunction {
    public static final String NAME = "TRIM";
    private TrimType type = TrimType.BOTH;
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The extracted string.", 0, true, 5), new Column("value", ParadoxType.VARCHAR, "The string to extract from.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Remove leading and trailing spaces from a string.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public boolean isVariableParameters() {
        return true;
    }

    @Override
    public int getMaxParameterCount() {
        return 3;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        if (values.length > 1 && values[1] == null) {
            return null;
        }
        if (values.length == 1) {
            return values[0].toString().trim();
        }
        String value = values[1].toString();
        char[] chars = values[0].toString().toCharArray();
        Arrays.sort(chars);
        StringBuilder ret = new StringBuilder(value);
        if (this.type == TrimType.BOTH || this.type == TrimType.LEADING) {
            while (ret.length() > 0 && Arrays.binarySearch(chars, ret.charAt(0)) > -1) {
                ret.deleteCharAt(0);
            }
        }
        if (this.type == TrimType.BOTH || this.type == TrimType.TRAILING) {
            while (ret.length() > 0 && Arrays.binarySearch(chars, ret.charAt(ret.length() - 1)) > -1) {
                ret.deleteCharAt(ret.length() - 1);
            }
        }
        return ret.toString();
    }

    @Override
    public void validate(List<SQLNode> parameters) throws ParadoxSyntaxErrorException {
        super.validate(parameters);
        if (parameters.size() > 2) {
            SQLNode value = parameters.get(0);
            this.type = Utils.searchEnum(TrimType.class, value.getName());
            if (this.type == null) {
                throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, value.getName());
            }
            parameters.remove(0);
        }
    }

    public static boolean isValidType(String value) {
        return Utils.searchEnum(TrimType.class, value) != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrimFunction that = (TrimFunction)o;
        return this.type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type});
    }

    private static enum TrimType {
        BOTH,
        LEADING,
        TRAILING;

    }
}

