/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;

public class SubstringFunction
extends AbstractStringFunction {
    public static final String NAME = "SUBSTRING";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The extracted string.", 0, false, 5), new Column("value", ParadoxType.VARCHAR, "The string to extract from.", 1, false, 1), new Column("start", ParadoxType.INTEGER, "The start position. Begin with 1.", 2, false, 1), new Column("length", ParadoxType.INTEGER, "The amount to extract.", 3, false, 1)};

    @Override
    public String getRemarks() {
        return "Extracts some characters from a string.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        int index = ValuesConverter.getPositiveInteger(values[1], connectionInfo) - 1;
        if (index == -1) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, values[1]);
        }
        String value = values[0].toString();
        if (index >= value.length()) {
            return "";
        }
        int length = ValuesConverter.getPositiveInteger(values[2], connectionInfo);
        if (index + length > value.length()) {
            return value.substring(index);
        }
        return value.substring(index, index + length);
    }
}

