/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;

public class SpaceFunction
extends AbstractStringFunction {
    public static final String NAME = "SPACE";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The string spaces.", 0, false, 5), new Column("space_count", ParadoxType.INTEGER, "The space count.", 1, true, 1)};

    @Override
    public String getRemarks() {
        return "Return a string only with spaces.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        int size = ValuesConverter.getPositiveInteger(values[0], connectionInfo);
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            ret.append(' ');
        }
        return ret.toString();
    }
}

