/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;

public class RepeatFunction
extends AbstractStringFunction {
    public static final String NAME = "REPEAT";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The string repeated.", 0, true, 5), new Column("string", ParadoxType.VARCHAR, "The string to repeat.", 1, false, 1), new Column("count", ParadoxType.INTEGER, "The repeat count.", 2, false, 1)};

    @Override
    public String getRemarks() {
        return "Return a repeated string a specified number of times.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        int size = ValuesConverter.getPositiveInteger(values[1], connectionInfo);
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            ret.append(values[0]);
        }
        return ret.toString();
    }
}

