/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;

public class OctetLengthFunction
extends AbstractStringFunction {
    public static final String NAME = "OCTET_LENGTH";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.INTEGER, "The bytes count.", 0, false, 5), new Column("bytes", ParadoxType.BLOB, "The byte values to count.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Gets the length of the binary values in bytes.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        Object value = values[0];
        int ret = 0;
        switch (types[0]) {
            case CHAR: 
            case MEMO: 
            case VARCHAR: {
                if (value == null) break;
                ret = value.toString().length();
                break;
            }
            case BLOB: 
            case OLE: 
            case GRAPHIC: 
            case BYTES: {
                ret = ((byte[])value).length;
                break;
            }
            default: {
                ret = types[0].getSize();
            }
        }
        return ret;
    }
}

