/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;

public class LeftFunction
extends AbstractStringFunction {
    public static final String NAME = "LEFT";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The extracted string.", 0, true, 5), new Column("string", ParadoxType.VARCHAR, "The string to extract", 1, false, 1), new Column("number_of_chars", ParadoxType.INTEGER, "The number of chars to extract", 2, false, 1)};

    @Override
    public String getRemarks() {
        return "Extract a part of the string from the left side.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        int size = ValuesConverter.getPositiveInteger(values[1], connectionInfo);
        StringBuilder ret = new StringBuilder(values[0].toString());
        if (ret.length() > size) {
            ret.delete(size, ret.length());
        }
        return ret.toString();
    }
}

