/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;

public class LPadFunction
extends AbstractStringFunction {
    public static final String NAME = "LPAD";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The left-padded string.", 0, true, 5), new Column("string", ParadoxType.VARCHAR, "The original string.", 1, false, 1), new Column("length", ParadoxType.VARCHAR, "The length of the final string.", 2, false, 1), new Column("lpad_string", ParadoxType.VARCHAR, "The filler string to use.", 3, false, 1)};

    @Override
    public String getRemarks() {
        return "Left-pads a string with another string, to a certain length.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        String value = values[0].toString();
        int size = ValuesConverter.getPositiveInteger(values[1], connectionInfo);
        if (value.length() > size) {
            return value.substring(0, size);
        }
        String pattern = values[2].toString();
        StringBuilder ret = new StringBuilder();
        while (ret.length() + value.length() < size) {
            ret.append(pattern);
        }
        return ret.substring(0, size - value.length()) + value;
    }
}

