/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;

public class InitCapFunction
extends AbstractStringFunction {
    public static final String NAME = "INITCAP";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The capitalized string.", 0, true, 5), new Column("string", ParadoxType.VARCHAR, "The string to capitalize", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Capitalize the string.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        char[] chars = values[0].toString().toLowerCase(connectionInfo.getLocale()).toCharArray();
        boolean found = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!found && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                found = true;
                continue;
            }
            if (!Character.isWhitespace(chars[i]) && chars[i] != '.' && chars[i] != '\'') continue;
            found = false;
        }
        return String.valueOf(chars);
    }
}

