/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.exceptions.ParadoxSyntaxErrorException;
import com.googlecode.paradox.exceptions.SyntaxError;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;

public class ConcatWSFunction
extends AbstractStringFunction {
    public static final String NAME = "CONCAT_WS";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The concatenated string.", 0, true, 5), new Column("separator", ParadoxType.VARCHAR, "The string separator", 1, true, 1), new Column("value", ParadoxType.VARCHAR, "The string to concatenate", 2, true, 1)};

    @Override
    public String getRemarks() {
        return "Concatenate a sequence of strings with a separator. This functions support any number of parameters above 1.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public boolean isVariableParameters() {
        return true;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws ParadoxSyntaxErrorException {
        Object separator = values[0];
        if (separator == null) {
            throw new ParadoxSyntaxErrorException(SyntaxError.INVALID_PARAMETER_VALUE, separator);
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 1; i < values.length; ++i) {
            Object value = values[i];
            if (value == null) continue;
            if (i != 1) {
                ret.append(separator);
            }
            ret.append(value);
        }
        return ret.toString();
    }
}

