/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;

public class ConcatFunction
extends AbstractStringFunction {
    public static final String NAME = "CONCAT";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The concatenated string.", 0, true, 5), new Column("value1", ParadoxType.VARCHAR, "The string to concatenate", 1, true, 1), new Column("value2", ParadoxType.VARCHAR, "The string to concatenate", 2, true, 1)};

    @Override
    public String getRemarks() {
        return "Concatenate a sequence of strings. This functions support any number of parameters.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public boolean isVariableParameters() {
        return true;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        StringBuilder ret = new StringBuilder();
        for (Object value : values) {
            if (value == null) continue;
            ret.append(value);
        }
        return ret.toString();
    }
}

