/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;

public class ChrFunction
extends AbstractStringFunction {
    public static final String NAME = "CHR";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.CHAR, "A char value.", 0, false, 5), new Column("number", ParadoxType.INTEGER, "The integer to convert.", 1, true, 1)};

    @Override
    public String getRemarks() {
        return "Converts a unicode integer value to char.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        int value = ValuesConverter.getPositiveInteger(values[0], connectionInfo);
        return Character.valueOf((char)value);
    }

    static {
        COLUMNS[0].setSize(1);
    }
}

