/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.string;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.string.AbstractStringFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import java.sql.SQLException;

public class AsciiFunction
extends AbstractStringFunction {
    public static final String NAME = "ASCII";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.INTEGER, "A unicode integer value.", 0, true, 5), new Column("integer", ParadoxType.CHAR, "The char value to convert.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Converts a character value to unicode integer value.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        Object value = values[0];
        if (value != null && !value.toString().isEmpty()) {
            return (int)value.toString().charAt(0);
        }
        return null;
    }

    static {
        COLUMNS[1].setSize(1);
    }
}

