/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class SquareFunction
extends AbstractNumericFunction {
    public static final String NAME = "SQUARE";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.NUMBER, "The number in power of 2.", 0, false, 5), new Column("number", ParadoxType.NUMBER, "A number to calculate the square of.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Returns the square of a number.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        Double value = ValuesConverter.getDouble(values[0], connectionInfo);
        if (value == null) {
            return null;
        }
        return Math.pow(value, 2.0);
    }
}

