/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class SignFunction
extends AbstractNumericFunction {
    public static final String NAME = "SIGN";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.INTEGER, "1 for positive, -1 for negative and 0 for zero.", 0, false, 5), new Column("number", ParadoxType.NUMBER, "The value to check.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Return the sign of a number.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        Double value = ValuesConverter.getDouble(values[0], connectionInfo);
        if (value == null) {
            return null;
        }
        return Math.signum(value);
    }
}

