/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class RoundFunction
extends AbstractNumericFunction {
    public static final String NAME = "ROUND";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.NUMBER, "The rounded number.", 0, false, 5), new Column("number", ParadoxType.NUMBER, "The number to be rounded.", 1, false, 1), new Column("decimal", ParadoxType.INTEGER, "The number of decimal places to round number to.", 2, false, 1), new Column("operation", ParadoxType.BOOLEAN, "If true, it rounds the result to the number of decimal, otherwise it truncates the result to the number of decimals. Default value is false.", 3, true, 1)};

    @Override
    public String getRemarks() {
        return "Returns a number to a specified number of decimal places.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public int getParameterCount() {
        return 2;
    }

    @Override
    public boolean isVariableParameters() {
        return true;
    }

    @Override
    public int getMaxParameterCount() {
        return 3;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        BigDecimal value = ValuesConverter.getBigDecimal(values[0], connectionInfo);
        Integer decimal = ValuesConverter.getInteger(values[1], connectionInfo);
        if (value == null || decimal == null) {
            return null;
        }
        Boolean rounding = null;
        if (values.length == 3) {
            rounding = ValuesConverter.getBoolean(values[2], connectionInfo);
        }
        RoundingMode mode = RoundingMode.HALF_UP;
        if (rounding != null && rounding.booleanValue()) {
            mode = RoundingMode.FLOOR;
        }
        return value.setScale((int)decimal, mode);
    }
}

