/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class PowerFunction
extends AbstractNumericFunction {
    public static final String NAME = "POWER";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.NUMBER, "A radian number.", 0, false, 5), new Column("number", ParadoxType.NUMBER, "The base number.", 1, false, 1), new Column("exponent", ParadoxType.NUMBER, "The exponent number.", 2, false, 1)};

    @Override
    public String getRemarks() {
        return "Returns the value of a number raised to the power of another number.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        Double value = ValuesConverter.getDouble(values[0], connectionInfo);
        Double exponent = ValuesConverter.getDouble(values[1], connectionInfo);
        if (value == null || exponent == null) {
            return null;
        }
        return Math.pow(value, exponent);
    }
}

