/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class LogFunction
extends AbstractNumericFunction {
    public static final String NAME = "LOG";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.NUMBER, "The logarithm of the number.", 0, false, 5), new Column("number", ParadoxType.NUMBER, "The number to return the natural logarithm of. Must be greater than 0.", 1, false, 1), new Column("base", ParadoxType.NUMBER, "The base the natural logarithm is to be calculated with. Must be greater than 1.", 2, true, 1)};

    @Override
    public String getRemarks() {
        return "Returns the natural logarithm of a specified number, or the logarithm of the number to the specified base.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public int getMaxParameterCount() {
        return 2;
    }

    @Override
    public boolean isVariableParameters() {
        return true;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        Double base;
        Double value = ValuesConverter.getDouble(values[0], connectionInfo);
        if (value == null) {
            return null;
        }
        if (values.length > 1 && (base = ValuesConverter.getDouble(values[1], connectionInfo)) != null) {
            return Math.log(value) / Math.log(base);
        }
        return Math.log(value);
    }
}

