/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class Log10Function
extends AbstractNumericFunction {
    public static final String NAME = "LOG10";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.NUMBER, "The the log of a number.", 0, false, 5), new Column("number", ParadoxType.NUMBER, "A number to calculate the log.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Returns the natural logarithm of a number to base 10.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        Double value = ValuesConverter.getDouble(values[0], connectionInfo);
        if (value == null) {
            return null;
        }
        return Math.log10(value);
    }
}

