/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class IsNumericFunction
extends AbstractNumericFunction {
    public static final String NAME = "ISNUMERIC";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.BOOLEAN, "True if the value is numeric.", 0, false, 5), new Column("number", ParadoxType.NUMBER, "The value to check.", 1, true, 1)};

    @Override
    public String getRemarks() {
        return "Checks if the value can be a numeric value.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        if (values[0] == null) {
            return 0;
        }
        if (ValuesConverter.getDouble(values[0], connectionInfo) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

