/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;

public class IntegerFunction
extends AbstractNumericFunction {
    public static final String NAME = "INTEGER";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.INTEGER, "A integer value.", 0, true, 5), new Column("integer", ParadoxType.VARCHAR, "A value to convert.", 1, true, 1)};

    @Override
    public String getRemarks() {
        return "Converts the value to integer type.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        return ValuesConverter.getInteger(values[0], connectionInfo);
    }
}

