/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;

public class DegreesFunction
extends AbstractNumericFunction {
    public static final String NAME = "DEGREES";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.NUMBER, "A degree number.", 0, false, 5), new Column("number", ParadoxType.NUMBER, "A radian number.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Converts a value in radians to degrees.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        Double value = ValuesConverter.getDouble(values[0], connectionInfo);
        if (value == null) {
            return null;
        }
        return Math.toDegrees(value);
    }
}

