/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.math.BigDecimal;

public class BinFunction
extends AbstractNumericFunction {
    public static final String NAME = "BIN";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.VARCHAR, "The the binary representation of a number.", 0, false, 5), new Column("number", ParadoxType.INTEGER, "A numeric value.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Returns a binary representation of a number, as a string value..";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) {
        BigDecimal value = ValuesConverter.getBigDecimal(values[0], connectionInfo);
        if (value == null) {
            return null;
        }
        return value.toBigInteger().toString(2);
    }
}

