/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.paradox.function.numeric;

import com.googlecode.paradox.ConnectionInfo;
import com.googlecode.paradox.function.numeric.AbstractNumericFunction;
import com.googlecode.paradox.planner.nodes.FieldNode;
import com.googlecode.paradox.results.Column;
import com.googlecode.paradox.results.ParadoxType;
import com.googlecode.paradox.rowset.ValuesConverter;
import java.sql.SQLException;

public class AbsFunction
extends AbstractNumericFunction {
    public static final String NAME = "ABS";
    private static final Column[] COLUMNS = new Column[]{new Column(null, ParadoxType.NUMBER, "A absolute value.", 0, true, 5), new Column("number", ParadoxType.NUMBER, "A numeric value.", 1, false, 1)};

    @Override
    public String getRemarks() {
        return "Returns the absolute value of a number.";
    }

    @Override
    public Column[] getColumns() {
        return COLUMNS;
    }

    @Override
    public Object execute(ConnectionInfo connectionInfo, Object[] values, ParadoxType[] types, FieldNode[] fields) throws SQLException {
        Double value = ValuesConverter.getDouble(values[0], connectionInfo);
        if (value == null) {
            return null;
        }
        return Math.abs(value);
    }
}

